/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.example;

import com.brunomnsilva.smartgraph.containers.SmartGraphDemoContainer;
import com.brunomnsilva.smartgraph.example.City;
import com.brunomnsilva.smartgraph.example.Distance;
import com.brunomnsilva.smartgraph.graph.GraphEdgeList;
import com.brunomnsilva.smartgraph.graph.Vertex;
import com.brunomnsilva.smartgraph.graphview.SmartCircularSortedPlacementStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartGraphPanel;
import com.brunomnsilva.smartgraph.graphview.SmartGraphProperties;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class ExampleMain
extends Application {
    public void start(Stage ignored) {
        GraphEdgeList<Object, Distance> distances = new GraphEdgeList<Object, Distance>();
        Vertex<City> prague = distances.insertVertex(new City("Prague", 1.3f));
        Vertex<City> tokyo = distances.insertVertex(new City("Tokyo", 37.5f));
        Vertex<City> beijing = distances.insertVertex(new City("Beijing", 21.5f));
        Vertex<City> newYork = distances.insertVertex(new City("New York", 19.5f));
        Vertex<City> london = distances.insertVertex(new City("London", 14.4f));
        Vertex<City> helsinky = distances.insertVertex(new City("Helsinky", 0.6f));
        distances.insertEdge(tokyo, newYork, new Distance(10838));
        distances.insertEdge(beijing, newYork, new Distance(11550));
        distances.insertEdge(beijing, tokyo, new Distance(1303));
        distances.insertEdge(london, newYork, new Distance(5567));
        distances.insertEdge(london, prague, new Distance(1264));
        distances.insertEdge(helsinky, tokyo, new Distance(7815));
        distances.insertEdge(prague, helsinky, new Distance(1845));
        distances.insertEdge(beijing, london, new Distance(8132));
        String customProps = "edge.label = true\nedge.arrow = true";
        SmartGraphProperties properties = new SmartGraphProperties(customProps);
        SmartGraphPanel graphView = new SmartGraphPanel(distances, properties, new SmartCircularSortedPlacementStrategy());
        Scene scene = new Scene((Parent)new SmartGraphDemoContainer(graphView), 1024.0, 768.0);
        Stage stage = new Stage(StageStyle.DECORATED);
        stage.setTitle("JavaFX SmartGraph City Distances");
        stage.setMinHeight(500.0);
        stage.setMinWidth(800.0);
        stage.setScene(scene);
        stage.show();
        graphView.init();
        graphView.setVertexPosition(beijing, 100.0, 100.0);
        graphView.setVertexPosition(helsinky, 924.0, 100.0);
        graphView.setVertexPosition(london, 200.0, 668.0);
        graphView.setVertexPosition(prague, 824.0, 668.0);
        graphView.setVertexPosition(tokyo, 512.0, 200.0);
        graphView.setVertexPosition(newYork, 512.0, 400.0);
        graphView.getStylableVertex(tokyo).setStyleInline("-fx-fill: url(\"file:squares.jpg\");");
        graphView.setVertexDoubleClickAction(graphVertex -> graphVertex.setStyleClass("myVertex"));
    }

    public static void main(String[] args) {
        ExampleMain.launch((String[])args);
    }
}

