/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.example;

import com.brunomnsilva.smartgraph.graphview.SmartLabelSource;
import com.brunomnsilva.smartgraph.graphview.SmartRadiusSource;
import com.brunomnsilva.smartgraph.graphview.SmartShapeTypeSource;
import java.util.Objects;

public class City {
    private String name;
    private float population;

    public City(String name, float population) {
        this.name = name;
        this.population = population;
    }

    @SmartLabelSource
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getPopulation() {
        return this.population;
    }

    public void setPopulation(float population) {
        this.population = population;
    }

    public String toString() {
        return "City{name=" + this.name + ", population=" + this.population + '}';
    }

    @SmartShapeTypeSource
    public String modelShape() {
        if (Objects.equals(this.name, "Tokyo")) {
            return "star";
        }
        return "circle";
    }

    @SmartRadiusSource
    public Double modelRadius() {
        return City.convertToLogScale(Double.parseDouble(String.valueOf(this.population)));
    }

    private static double convertToLogScale(double value) {
        double minValue = 1.0;
        double maxValue = 40.0;
        double minOutputValue = 15.0;
        double maxOutputValue = 40.0;
        double mappedValue = (Math.log(value) - Math.log(minValue)) / (Math.log(maxValue) - Math.log(minValue));
        return minOutputValue + mappedValue * (maxOutputValue - minOutputValue);
    }
}

