/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.containers;

import com.brunomnsilva.smartgraph.containers.ContentZoomScrollPane;
import com.brunomnsilva.smartgraph.graphview.SmartGraphPanel;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class SmartGraphDemoContainer
extends BorderPane {
    private final ContentZoomScrollPane contentZoomPane;

    public SmartGraphDemoContainer(SmartGraphPanel<?, ?> graphView) {
        if (graphView == null) {
            throw new IllegalArgumentException("View cannot be null.");
        }
        this.contentZoomPane = new ContentZoomScrollPane(graphView);
        this.setCenter((Node)this.contentZoomPane);
        Background background = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
        this.setRight(this.createSidebar(this.contentZoomPane, background));
        this.setBottom(this.createBottomBar(graphView, background));
    }

    private Node createBottomBar(SmartGraphPanel<?, ?> view, Background bg) {
        HBox bar = new HBox(20.0);
        bar.setAlignment(Pos.CENTER);
        bar.setPadding(new Insets(10.0));
        bar.setBackground(bg);
        CheckBox automatic = new CheckBox("Automatic layout");
        automatic.selectedProperty().bindBidirectional((Property)view.automaticLayoutProperty());
        Button btUpdate = new Button("Force update");
        btUpdate.setOnAction(actionEvent -> view.update());
        Text helpLabel = new Text("?");
        helpLabel.setStyle("-fx-font-size: 14px; -fx-font-weight: bold;");
        Tooltip tooltip = new Tooltip("Mouse wheel to zoom; left-click to drag and interact with nodes; drag area (any button) for panning.");
        Tooltip.install((Node)helpLabel, (Tooltip)tooltip);
        bar.getChildren().addAll((Object[])new Node[]{automatic, new Separator(Orientation.VERTICAL), btUpdate, new Separator(Orientation.VERTICAL), helpLabel});
        return bar;
    }

    private Node createSidebar(ContentZoomScrollPane zoomPane, Background bg) {
        VBox paneSlider = new VBox(10.0);
        paneSlider.setAlignment(Pos.CENTER);
        paneSlider.setPadding(new Insets(10.0));
        paneSlider.setSpacing(10.0);
        paneSlider.setBackground(bg);
        Slider slider = new Slider(zoomPane.getMinScaleFactor(), zoomPane.getMaxScaleFactor(), zoomPane.getMinScaleFactor());
        slider.setOrientation(Orientation.VERTICAL);
        slider.setShowTickMarks(true);
        slider.setShowTickLabels(true);
        slider.setMajorTickUnit(zoomPane.getDeltaScaleFactor());
        slider.setMinorTickCount(1);
        slider.setBlockIncrement(0.125);
        slider.setSnapToTicks(true);
        slider.valueProperty().bind((ObservableValue)zoomPane.scaleFactorProperty());
        paneSlider.getChildren().addAll((Object[])new Node[]{slider, new Text("Zoom")});
        return paneSlider;
    }
}

