/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph;

import com.brunomnsilva.smartgraph.containers.SmartGraphDemoContainer;
import com.brunomnsilva.smartgraph.graph.DigraphEdgeList;
import com.brunomnsilva.smartgraph.graph.Graph;
import com.brunomnsilva.smartgraph.graph.GraphEdgeList;
import com.brunomnsilva.smartgraph.graph.Vertex;
import com.brunomnsilva.smartgraph.graphview.ForceDirectedSpringGravityLayoutStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartCircularSortedPlacementStrategy;
import com.brunomnsilva.smartgraph.graphview.SmartGraphPanel;
import com.brunomnsilva.smartgraph.graphview.SmartStylableNode;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Main
extends Application {
    private volatile boolean running;
    private static final Random random = new Random();

    public void start(Stage ignored) {
        Graph<String, String> g = this.build_sample_digraph();
        System.out.println(g);
        SmartCircularSortedPlacementStrategy initialPlacement = new SmartCircularSortedPlacementStrategy();
        ForceDirectedSpringGravityLayoutStrategy automaticPlacementStrategy = new ForceDirectedSpringGravityLayoutStrategy();
        SmartGraphPanel<String, String> graphView = new SmartGraphPanel<String, String>(g, initialPlacement, automaticPlacementStrategy);
        if (g.numVertices() > 0) {
            graphView.getStylableVertex("A").setStyleInline("-fx-fill: gold; -fx-stroke: brown;");
        }
        Scene scene = new Scene((Parent)new SmartGraphDemoContainer(graphView), 1024.0, 768.0);
        Stage stage = new Stage(StageStyle.DECORATED);
        stage.setTitle("JavaFX SmartGraph Visualization");
        stage.setMinHeight(500.0);
        stage.setMinWidth(800.0);
        stage.setScene(scene);
        stage.show();
        graphView.init();
        graphView.setVertexDoubleClickAction(graphVertex -> {
            System.out.println("Vertex contains element: " + (String)graphVertex.getUnderlyingVertex().element());
            if (!graphVertex.removeStyleClass("myVertex")) {
                graphVertex.addStyleClass("myVertex");
            }
        });
        graphView.setEdgeDoubleClickAction(graphEdge -> {
            System.out.println("Edge contains element: " + (String)graphEdge.getUnderlyingEdge().element());
            graphEdge.setStyleClass("myEdge");
        });
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    private Graph<String, String> build_sample_digraph() {
        DigraphEdgeList<String, String> g = new DigraphEdgeList<String, String>();
        g.insertVertex("A");
        g.insertVertex("B");
        g.insertVertex("C");
        g.insertVertex("D");
        g.insertVertex("E");
        g.insertVertex("F");
        g.insertEdge("A", "B", "AB");
        g.insertEdge("B", "A", "AB2");
        g.insertEdge("A", "C", "AC");
        g.insertEdge("A", "D", "AD");
        g.insertEdge("B", "C", "BC");
        g.insertEdge("C", "D", "CD");
        g.insertEdge("B", "E", "BE");
        g.insertEdge("F", "D", "DF");
        g.insertEdge("F", "D", "DF2");
        g.insertEdge("A", "A", "Loop");
        return g;
    }

    private Graph<String, String> build_flower_graph() {
        GraphEdgeList<String, String> g = new GraphEdgeList<String, String>();
        g.insertVertex("A");
        g.insertVertex("B");
        g.insertVertex("C");
        g.insertVertex("D");
        g.insertVertex("E");
        g.insertVertex("F");
        g.insertVertex("G");
        g.insertEdge("A", "B", "1");
        g.insertEdge("A", "C", "2");
        g.insertEdge("A", "D", "3");
        g.insertEdge("A", "E", "4");
        g.insertEdge("A", "F", "5");
        g.insertEdge("A", "G", "6");
        g.insertVertex("H");
        g.insertVertex("I");
        g.insertVertex("J");
        g.insertVertex("K");
        g.insertVertex("L");
        g.insertVertex("M");
        g.insertVertex("N");
        g.insertEdge("H", "I", "7");
        g.insertEdge("H", "J", "8");
        g.insertEdge("H", "K", "9");
        g.insertEdge("H", "L", "10");
        g.insertEdge("H", "M", "11");
        g.insertEdge("H", "N", "12");
        g.insertEdge("A", "H", "0");
        return g;
    }

    private void continuously_test_adding_elements(Graph<String, String> g, SmartGraphPanel<String, String> graphView) {
        this.running = true;
        long ITERATION_WAIT = 3000L;
        Runnable r = () -> {
            int count = 0;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            while (this.running) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                String id = String.format("%02d", ++count);
                if (random.nextInt(3) < 2) {
                    Vertex<String> existing = Main.get_random_vertex(g);
                    Vertex<String> vertexId = g.insertVertex("V" + id);
                    g.insertEdge((String)((Object)existing), (String)((Object)vertexId), "E" + id);
                    graphView.updateAndWait();
                    SmartStylableNode stylableVertex = graphView.getStylableVertex((String)((Object)vertexId));
                    if (stylableVertex == null) continue;
                    stylableVertex.setStyleInline("-fx-fill: orange;");
                    continue;
                }
                Vertex<String> existing1 = Main.get_random_vertex(g);
                Vertex<String> existing2 = Main.get_random_vertex(g);
                g.insertEdge((String)((Object)existing1), (String)((Object)existing2), "E" + id);
                graphView.update();
            }
        };
        new Thread(r).start();
    }

    private static Vertex<String> get_random_vertex(Graph<String, String> g) {
        int size = g.numVertices();
        int rand = random.nextInt(size);
        Vertex<String> existing = null;
        int i = 0;
        Iterator<Vertex<String>> iterator = g.vertices().iterator();
        while (iterator.hasNext()) {
            Vertex<String> v;
            existing = v = iterator.next();
            if (i++ != rand) continue;
            break;
        }
        return existing;
    }
}

