/*
 * Decompiled with CFR 0.152.
 */
package com.brianfromoregon;

import com.brianfromoregon.BuildResultDifference;
import com.brianfromoregon.BuildResults;
import com.brianfromoregon.ScenarioKey;
import com.brianfromoregon.ScenarioResultChange;
import com.brianfromoregon.ScenarioTrend;
import com.google.caliper.Json;
import com.google.caliper.Result;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.util.Graph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.Stapler;

public class CaliperBuildAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(CaliperBuildAction.class.getName());
    private final String[] jsonResults;
    public final AbstractBuild<?, ?> build;
    private transient BuildResults results;
    private transient Map<Integer, ScenarioTrend> trendsById;

    public CaliperBuildAction(String[] jsonResults, AbstractBuild<?, ?> build) {
        this.jsonResults = jsonResults;
        this.build = build;
        this.initResults();
    }

    public Iterable<ScenarioResultChange> getScenarioResultChanges() {
        return Iterables.filter(this.getResultDifference().changes, (Predicate)new Predicate<ScenarioResultChange>(){

            public boolean apply(ScenarioResultChange input) {
                return input.getTimeType() != ScenarioResultChange.Type.NO_RESULT;
            }
        });
    }

    public Iterable<ScenarioTrend> getScenarioTrends() {
        return this.trendsById.values();
    }

    public String getSummary() {
        BuildResultDifference diff = this.getResultDifference();
        int memResults = diff.getNumMemoryResults();
        int memRegressions = diff.getNumMemoryRegressions();
        int timingResults = diff.getNumTimingResults();
        return String.format("Collected %d timing result%s, %d memory result%s, found %d regression%s", timingResults, timingResults == 1 ? "" : "s", memResults, memResults == 1 ? "" : "s", memRegressions, memRegressions == 1 ? "" : "s");
    }

    public BuildResultDifference getResultDifference() {
        CaliperBuildAction prevAction;
        BuildResults prevResults = null;
        AbstractBuild prevBuild = (AbstractBuild)this.build.getPreviousBuiltBuild();
        if (prevBuild != null && (prevAction = (CaliperBuildAction)prevBuild.getAction(CaliperBuildAction.class)) != null) {
            prevResults = prevAction.results;
        }
        return new BuildResultDifference(prevResults, this.results);
    }

    public List<Result> jsonToResults() {
        ArrayList caliperResults = Lists.newArrayList();
        for (String r : this.jsonResults) {
            try {
                caliperResults.add(Json.getGsonInstance().fromJson(r, Result.class));
            }
            catch (JsonSyntaxException e) {
                LOGGER.log(Level.SEVERE, "Could not parse Caliper result file as JSON, skipping", e);
            }
        }
        return caliperResults;
    }

    public BuildResults getResults() {
        return this.results;
    }

    public String getIconFileName() {
        return "/plugin/caliper-ci/caliper.png";
    }

    public String getDisplayName() {
        return "Caliper";
    }

    public String getUrlName() {
        return "caliper";
    }

    public Graph getTimingTrendGraph() {
        int id;
        try {
            id = Integer.parseInt(Stapler.getCurrentRequest().getParameter("id"));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Could not parse graph request id as int", e);
            return null;
        }
        return this.trendsById.get(id).createGraph();
    }

    private void initResults() {
        this.results = new BuildResults(this.jsonToResults());
        this.trendsById = Maps.newHashMap();
        int id = 0;
        for (ScenarioKey key : this.results.getScenarios().keySet()) {
            this.trendsById.put(id, new ScenarioTrend(key, this.build, id++));
        }
    }

    private Object readResolve() {
        this.initResults();
        return this;
    }
}

