/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.widget.ImageView;
import android.widget.TextView;
import com.braze.models.cards.Card;
import com.braze.models.cards.ShortNewsCard;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.feed.view.BaseFeedCardView;

public class ShortNewsCardView
extends BaseFeedCardView<ShortNewsCard> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(ShortNewsCardView.class);
    private final ImageView mImage;
    private final TextView mTitle;
    private final TextView mDescription = (TextView)this.findViewById(R.id.com_braze_short_news_card_description);
    private final TextView mDomain;
    private IAction mCardAction;
    private final float mAspectRatio = 1.0f;

    public ShortNewsCardView(Context context) {
        this(context, null);
    }

    public ShortNewsCardView(Context context, ShortNewsCard card) {
        super(context);
        this.mTitle = (TextView)this.findViewById(R.id.com_braze_short_news_card_title);
        this.mDomain = (TextView)this.findViewById(R.id.com_braze_short_news_card_domain);
        this.mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_braze_short_news_card_imageview_stub);
        this.mImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mImage.setAdjustViewBounds(true);
        if (card != null) {
            this.setCard(card);
        }
        this.setBackground(this.getResources().getDrawable(R.drawable.com_braze_card_background, null));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_braze_short_news_card;
    }

    @Override
    public void onSetCard(ShortNewsCard card) {
        this.mDescription.setText((CharSequence)card.getDescription());
        this.setOptionalTextView(this.mTitle, card.getTitle());
        this.setOptionalTextView(this.mDomain, card.getDomain());
        this.mCardAction = ShortNewsCardView.getUriActionForCard((Card)card);
        this.setOnClickListener(view -> this.handleCardClick(this.applicationContext, (Card)card, this.mCardAction));
        this.setImageViewToUrl(this.mImage, card.getImageUrl(), 1.0f, (Card)card);
    }
}

