/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.MerchantAccount;
import com.braintreegateway.OAuthCredentials;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.List;

public class Merchant {
    private String id;
    private String email;
    private String companyName;
    private String countryCodeAlpha3;
    private String countryCodeAlpha2;
    private String countryCodeNumeric;
    private String countryName;
    private OAuthCredentials credentials;
    private List<MerchantAccount> merchantAccounts;

    public Merchant(NodeWrapper node) {
        NodeWrapper merchantNode = node.findFirst("merchant");
        this.id = merchantNode.findString("id");
        this.email = merchantNode.findString("email");
        this.companyName = merchantNode.findString("company-name");
        this.countryCodeAlpha3 = merchantNode.findString("country-code-alpha3");
        this.countryCodeAlpha2 = merchantNode.findString("country-code-alpha2");
        this.countryCodeNumeric = merchantNode.findString("country-code-numeric");
        this.countryName = merchantNode.findString("country-name");
        this.credentials = new OAuthCredentials(node.findFirst("credentials"));
        this.merchantAccounts = new ArrayList<MerchantAccount>();
        for (NodeWrapper merchantAccountsResponse : merchantNode.findAll("merchant-accounts/merchant-account")) {
            this.merchantAccounts.add(new MerchantAccount(merchantAccountsResponse));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getCountryCodeAlpha3() {
        return this.countryCodeAlpha3;
    }

    public String getCountryCodeAlpha2() {
        return this.countryCodeAlpha2;
    }

    public String getCountryCodeNumeric() {
        return this.countryCodeNumeric;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public OAuthCredentials getCredentials() {
        return this.credentials;
    }

    public List<MerchantAccount> getMerchantAccounts() {
        return this.merchantAccounts;
    }
}

