/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AuthenticationInsight;
import com.braintreegateway.BinData;
import com.braintreegateway.PaymentMethodNonceDetails;
import com.braintreegateway.ThreeDSecureInfo;
import com.braintreegateway.util.NodeWrapper;
import java.util.Map;

public class PaymentMethodNonce {
    private Boolean isDefault;
    private String publicId;
    private Boolean isLocked;
    private Boolean isConsumed;
    private PaymentMethodNonceDetails details;
    private ThreeDSecureInfo threeDSecureInfo;
    private String type;
    private BinData binData;
    private AuthenticationInsight authenticationInsight;

    public PaymentMethodNonce(NodeWrapper node) {
        NodeWrapper authenticationInsightNode;
        NodeWrapper binDataNode;
        NodeWrapper threeDSecureInfoNode;
        this.isDefault = node.findBoolean("default");
        this.publicId = node.findString("nonce");
        this.isLocked = node.findBoolean("locked");
        this.isConsumed = node.findBoolean("consumed");
        this.type = node.findString("type");
        NodeWrapper detailsNode = node.findFirst("details");
        if (detailsNode != null && !detailsNode.isBlank()) {
            this.details = new PaymentMethodNonceDetails(detailsNode);
        }
        if ((threeDSecureInfoNode = node.findFirst("three-d-secure-info")) != null && !threeDSecureInfoNode.isBlank()) {
            this.threeDSecureInfo = new ThreeDSecureInfo(threeDSecureInfoNode);
        }
        if ((binDataNode = node.findFirst("bin-data")) != null && !binDataNode.isBlank()) {
            this.binData = new BinData(binDataNode);
        }
        if ((authenticationInsightNode = node.findFirst("authentication-insight")) != null && !authenticationInsightNode.isBlank()) {
            this.authenticationInsight = new AuthenticationInsight(authenticationInsightNode);
        }
    }

    public PaymentMethodNonce(Map<String, Object> map) {
        Map authenticationInsightMap;
        Map binDataMap;
        Map threeDSecureInfoMap;
        this.isDefault = (Boolean)map.get("default");
        this.publicId = (String)map.get("nonce");
        this.isLocked = (Boolean)map.get("locked");
        this.isConsumed = (Boolean)map.get("consumed");
        this.type = (String)map.get("type");
        Map detailsMap = (Map)map.get("details");
        if (detailsMap != null) {
            this.details = new PaymentMethodNonceDetails(detailsMap);
        }
        if ((threeDSecureInfoMap = (Map)map.get("threeDSecureInfo")) != null) {
            this.threeDSecureInfo = new ThreeDSecureInfo(threeDSecureInfoMap);
        }
        if ((binDataMap = (Map)map.get("binData")) != null) {
            this.binData = new BinData(binDataMap);
        }
        if ((authenticationInsightMap = (Map)map.get("authenticationInsight")) != null) {
            this.authenticationInsight = new AuthenticationInsight(authenticationInsightMap);
        }
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getNonce() {
        return this.getPublicId();
    }

    public Boolean isLocked() {
        return this.isLocked;
    }

    public Boolean isConsumed() {
        return this.isConsumed;
    }

    public PaymentMethodNonceDetails getDetails() {
        return this.details;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.threeDSecureInfo;
    }

    public String getType() {
        return this.type;
    }

    public BinData getBinData() {
        return this.binData;
    }

    public AuthenticationInsight getAuthenticationInsight() {
        return this.authenticationInsight;
    }
}

