/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.CreditCardVerification;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.enums.Business;
import com.braintreegateway.enums.Consumer;
import com.braintreegateway.enums.Corporate;
import com.braintreegateway.enums.PrepaidReloadable;
import com.braintreegateway.enums.Purchase;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CreditCard
implements PaymentMethod {
    public static final String VALUE_YES = "Yes";
    public static final String VALUE_NO = "No";
    public static final String VALUE_UNKNOWN = "Unknown";
    private String accountType;
    private Address billingAddress;
    private String bin;
    private String binExtended;
    private String business;
    private String cardholderName;
    private String cardType;
    private String commercial;
    private String consumer;
    private String corporate;
    private String countryOfIssuance;
    private Calendar createdAt;
    private String customerId;
    private String customerLocation;
    private String debit;
    private String durbinRegulated;
    private String expirationMonth;
    private String expirationYear;
    private String healthcare;
    private String imageUrl;
    private boolean isDefault;
    private boolean isExpired;
    private boolean isNetworkTokenized;
    private boolean isVenmoSdk;
    private String issuingBank;
    private String last4;
    private String payroll;
    private String prepaid;
    private String prepaidReloadable;
    private String productId;
    private String purchase;
    private List<Subscription> subscriptions;
    private String token;
    private String uniqueNumberIdentifier;
    private Calendar updatedAt;
    private CreditCardVerification verification;

    public CreditCard(NodeWrapper node) {
        this.accountType = node.findString("account-type");
        NodeWrapper billingAddressResponse = node.findFirst("billing-address");
        if (billingAddressResponse != null) {
            this.billingAddress = new Address(billingAddressResponse);
        }
        this.bin = node.findString("bin");
        this.binExtended = node.findString("bin-extended");
        this.business = node.findString("business");
        this.cardholderName = node.findString("cardholder-name");
        this.cardType = node.findString("card-type");
        this.commercial = node.findString("commercial");
        this.consumer = node.findString("consumer");
        this.corporate = node.findString("corporate");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.createdAt = node.findDateTime("created-at");
        this.customerId = node.findString("customer-id");
        this.customerLocation = node.findString("customer-location");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.healthcare = node.findString("healthcare");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.isExpired = node.findBoolean("expired");
        this.isNetworkTokenized = node.findBoolean("is-network-tokenized");
        this.issuingBank = node.findString("issuing-bank");
        this.isVenmoSdk = node.findBoolean("venmo-sdk");
        this.last4 = node.findString("last-4");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.prepaidReloadable = node.findString("prepaid-reloadable");
        this.productId = node.findString("product-id");
        this.purchase = node.findString("purchase");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.token = node.findString("token");
        this.uniqueNumberIdentifier = node.findString("unique-number-identifier");
        this.updatedAt = node.findDateTime("updated-at");
        List<NodeWrapper> verificationNodes = node.findAll("verifications/verification");
        this.verification = this.findNewestVerification(verificationNodes);
    }

    private CreditCardVerification findNewestVerification(List<NodeWrapper> verificationNodes) {
        if (verificationNodes.size() > 0) {
            Collections.sort(verificationNodes, new Comparator<NodeWrapper>(){

                @Override
                public int compare(NodeWrapper node1, NodeWrapper node2) {
                    Calendar createdAt1 = node1.findDateTime("created-at");
                    Calendar createdAt2 = node2.findDateTime("created-at");
                    return createdAt2.compareTo(createdAt1);
                }
            });
            return new CreditCardVerification(verificationNodes.get(0));
        }
        return null;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getBin() {
        return this.bin;
    }

    public String getBinExtended() {
        return this.binExtended;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getCardType() {
        return this.cardType;
    }

    public Business getBusiness() {
        return (Business)EnumUtils.findByToString((Enum[])Business.values(), (String)this.business, (Enum)Business.UNKNOWN);
    }

    public Commercial getCommercial() {
        return (Commercial)EnumUtils.findByToString((Enum[])Commercial.values(), (String)this.commercial, (Enum)Commercial.UNKNOWN);
    }

    public Consumer getConsumer() {
        return (Consumer)EnumUtils.findByToString((Enum[])Consumer.values(), (String)this.consumer, (Enum)Consumer.UNKNOWN);
    }

    public Corporate getCorporate() {
        return (Corporate)EnumUtils.findByToString((Enum[])Corporate.values(), (String)this.corporate, (Enum)Corporate.UNKNOWN);
    }

    public String getCountryOfIssuance() {
        if ("".equals(this.countryOfIssuance)) {
            return VALUE_UNKNOWN;
        }
        return this.countryOfIssuance;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerLocation() {
        return this.customerLocation;
    }

    public Debit getDebit() {
        return (Debit)EnumUtils.findByToString((Enum[])Debit.values(), (String)this.debit, (Enum)Debit.UNKNOWN);
    }

    public DurbinRegulated getDurbinRegulated() {
        return (DurbinRegulated)EnumUtils.findByToString((Enum[])DurbinRegulated.values(), (String)this.durbinRegulated, (Enum)DurbinRegulated.UNKNOWN);
    }

    public String getExpirationDate() {
        return this.expirationMonth + "/" + this.expirationYear;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public Healthcare getHealthcare() {
        return (Healthcare)EnumUtils.findByToString((Enum[])Healthcare.values(), (String)this.healthcare, (Enum)Healthcare.UNKNOWN);
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getIssuingBank() {
        if ("".equals(this.issuingBank)) {
            return VALUE_UNKNOWN;
        }
        return this.issuingBank;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getMaskedNumber() {
        return this.getBin() + "******" + this.getLast4();
    }

    public Payroll getPayroll() {
        return (Payroll)EnumUtils.findByToString((Enum[])Payroll.values(), (String)this.payroll, (Enum)Payroll.UNKNOWN);
    }

    public Prepaid getPrepaid() {
        return (Prepaid)EnumUtils.findByToString((Enum[])Prepaid.values(), (String)this.prepaid, (Enum)Prepaid.UNKNOWN);
    }

    public PrepaidReloadable getPrepaidReloadable() {
        return (PrepaidReloadable)EnumUtils.findByToString((Enum[])PrepaidReloadable.values(), (String)this.prepaidReloadable, (Enum)PrepaidReloadable.UNKNOWN);
    }

    public String getProductId() {
        if ("".equals(this.productId)) {
            return VALUE_UNKNOWN;
        }
        return this.productId;
    }

    public Purchase getPurchase() {
        return (Purchase)EnumUtils.findByToString((Enum[])Purchase.values(), (String)this.purchase, (Enum)Purchase.UNKNOWN);
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public String getUniqueNumberIdentifier() {
        return this.uniqueNumberIdentifier;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public CreditCardVerification getVerification() {
        return this.verification;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public boolean isNetworkTokenized() {
        return this.isNetworkTokenized;
    }

    @Deprecated
    public boolean isVenmoSdk() {
        return this.isVenmoSdk;
    }

    public static enum DebitNetwork {
        ACCEL,
        MAESTRO,
        NYCE,
        PULSE,
        STAR,
        STAR_ACCESS;

    }

    public static enum Prepaid {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Prepaid(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Payroll {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Payroll(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Healthcare {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Healthcare(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DurbinRegulated {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private DurbinRegulated(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Debit {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Debit(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Commercial {
        YES("Yes"),
        NO("No"),
        UNKNOWN("Unknown");

        private final String value;

        private Commercial(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum CustomerLocation {
        INTERNATIONAL("international"),
        US("us");

        private final String name;

        private CustomerLocation(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum CardType {
        AMEX("American Express"),
        CARTE_BLANCHE("Carte Blanche"),
        CHINA_UNION_PAY("China UnionPay"),
        DINERS_CLUB_INTERNATIONAL("Diners Club"),
        DISCOVER("Discover"),
        ELO("Elo"),
        JCB("JCB"),
        LASER("Laser"),
        UK_MAESTRO("UK Maestro"),
        MAESTRO("Maestro"),
        MASTER_CARD("MasterCard"),
        SOLO("Solo"),
        SWITCH("Switch"),
        VISA("Visa");

        private final String name;

        private CardType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

