/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

public class EnumUtils {
    public static <T extends Enum<T>> T findByName(Class<T> enumType, String name, T defaultValue) {
        if (name == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, name.toUpperCase().replace(' ', '_'));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T findByToString(T[] values, String name, T defaultValue) {
        if (name == null || values == null) {
            return defaultValue;
        }
        for (T value : values) {
            if (!name.equals(((Enum)value).toString())) continue;
            return value;
        }
        return defaultValue;
    }
}

