/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Request;
import com.braintreegateway.Result;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.exceptions.UnexpectedException;
import com.braintreegateway.graphql.enums.RecommendedPaymentOption;
import com.braintreegateway.graphql.inputs.CreateCustomerSessionInput;
import com.braintreegateway.graphql.inputs.CustomerRecommendationsInput;
import com.braintreegateway.graphql.inputs.UpdateCustomerSessionInput;
import com.braintreegateway.graphql.types.CustomerRecommendationsPayload;
import com.braintreegateway.graphql.types.PaymentOptions;
import com.braintreegateway.graphql.unions.CustomerRecommendations;
import com.braintreegateway.util.GraphQLClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CustomerSessionGateway {
    private static final String CREATE_CUSTOMER_SESSION = "mutation CreateCustomerSession($input: CreateCustomerSessionInput!) { createCustomerSession(input: $input) {    sessionId  }}";
    private static final String UPDATE_CUSTOMER_SESSION = "mutation UpdateCustomerSession($input: UpdateCustomerSessionInput!) { updateCustomerSession(input: $input) {    sessionId  }}";
    private static final String GET_CUSTOMER_RECOMMENDATIONS = "query CustomerRecommendations($input: CustomerRecommendationsInput!) {\n            customerRecommendations(input: $input) {\n              isInPayPalNetwork\n              recommendations {\n                ... on PaymentRecommendations {\n                  paymentOptions {\n                    paymentOption\n                    recommendedPriority\n                  }\n                }\n              }\n            }\n          }";
    private final GraphQLClient graphQLClient;

    public CustomerSessionGateway(GraphQLClient graphQLClient) {
        this.graphQLClient = graphQLClient;
    }

    public Result<String> createCustomerSession(CreateCustomerSessionInput input) {
        return this.executeMutation(CREATE_CUSTOMER_SESSION, input, "data.createCustomerSession.sessionId");
    }

    public Result<String> updateCustomerSession(UpdateCustomerSessionInput input) {
        return this.executeMutation(UPDATE_CUSTOMER_SESSION, input, "data.updateCustomerSession.sessionId");
    }

    public Result<CustomerRecommendationsPayload> getCustomerRecommendations(CustomerRecommendationsInput CustomerRecommendationsInput2) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input", CustomerRecommendationsInput2.toGraphQLVariables());
        try {
            Map<String, Object> response = this.graphQLClient.query(GET_CUSTOMER_RECOMMENDATIONS, variables);
            ValidationErrors errors = GraphQLClient.getErrors(response);
            if (errors != null) {
                return new Result<CustomerRecommendationsPayload>(errors);
            }
            return new Result<CustomerRecommendationsPayload>(CustomerSessionGateway.extractCustomerRecommendationsPayload(response));
        }
        catch (Throwable e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private Result<String> executeMutation(String query, Request input, String sessionIdKey) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input", input.toGraphQLVariables());
        try {
            Map<String, Object> response = this.graphQLClient.query(query, variables);
            ValidationErrors errors = GraphQLClient.getErrors(response);
            if (errors != null) {
                return new Result<String>(errors);
            }
            String sessionId = (String)CustomerSessionGateway.getValue(response, sessionIdKey);
            return new Result<String>(sessionId);
        }
        catch (Throwable e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private static CustomerRecommendationsPayload extractCustomerRecommendationsPayload(Map<String, Object> response) {
        boolean isInPayPalNetwork = (Boolean)CustomerSessionGateway.getValue(response, "data.customerRecommendations.isInPayPalNetwork");
        CustomerRecommendations recommendations = CustomerSessionGateway.extractRecommendations(response);
        return new CustomerRecommendationsPayload(isInPayPalNetwork, recommendations);
    }

    private static CustomerRecommendations extractRecommendations(Map<String, Object> response) {
        List paymentOptionsObjs = (List)CustomerSessionGateway.getValue(response, "data.customerRecommendations.recommendations.paymentOptions");
        List<PaymentOptions> paymentOptionsList = paymentOptionsObjs.stream().map(paymentOptionsObj -> {
            Integer recommendedPriority = (Integer)CustomerSessionGateway.getValue(paymentOptionsObj, "recommendedPriority");
            String paymentOptionString = (String)CustomerSessionGateway.getValue(paymentOptionsObj, "paymentOption");
            RecommendedPaymentOption paymentOption = RecommendedPaymentOption.valueOf(paymentOptionString);
            return new PaymentOptions(paymentOption, recommendedPriority);
        }).collect(Collectors.toList());
        return new CustomerRecommendations(paymentOptionsList);
    }

    private static <T> T getValue(Map<String, Object> response, String key) {
        Map map = response;
        String[] keyParts = key.split("\\.");
        for (int k = 0; k < keyParts.length - 1; ++k) {
            String subKey = keyParts[k];
            map = (Map)CustomerSessionGateway.popValue(map, subKey);
        }
        String lastKey = keyParts[keyParts.length - 1];
        return CustomerSessionGateway.popValue(map, lastKey);
    }

    private static <T> T popValue(Map<String, Object> response, String key) {
        if (!response.containsKey(key)) {
            throw new UnexpectedException("Couldn't parse response");
        }
        return (T)response.get(key);
    }
}

