/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CustomerRequest;
import com.braintreegateway.ExternalVaultRequest;
import com.braintreegateway.InstallmentRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.RiskDataTransactionRequest;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionAddressRequest;
import com.braintreegateway.TransactionAndroidPayCardRequest;
import com.braintreegateway.TransactionApplePayCardRequest;
import com.braintreegateway.TransactionCreditCardRequest;
import com.braintreegateway.TransactionDescriptorRequest;
import com.braintreegateway.TransactionIndustryRequest;
import com.braintreegateway.TransactionLineItemRequest;
import com.braintreegateway.TransactionOptionsRequest;
import com.braintreegateway.TransactionPayPalRequest;
import com.braintreegateway.TransactionThreeDSecurePassThruRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionRequest
extends Request {
    private BigDecimal amount;
    private TransactionAddressRequest billingAddressRequest;
    private String deviceData;
    private TransactionCreditCardRequest creditCardRequest;
    private TransactionPayPalRequest paypalRequest;
    private String channel;
    private String customerId;
    private String deviceSessionId;
    private String exchangeRateQuoteId;
    private String fraudMerchantId;
    private CustomerRequest customerRequest;
    private Map<String, String> customFields = new HashMap<String, String>();
    private String merchantAccountId;
    private String orderId;
    private String paymentMethodToken;
    private String purchaseOrderNumber;
    private Boolean recurring;
    private Transaction.ScaExemption scaExemption;
    private String source;
    private String shippingAddressId;
    private String billingAddressId;
    private TransactionApplePayCardRequest applePayCardRequest;
    private TransactionAndroidPayCardRequest androidPayCardRequest;
    private TransactionDescriptorRequest descriptorRequest;
    private TransactionIndustryRequest industryRequest;
    private TransactionAddressRequest shippingAddressRequest;
    private TransactionOptionsRequest transactionOptionsRequest;
    private TransactionThreeDSecurePassThruRequest threeDSecurePassThruRequest;
    private BigDecimal taxAmount;
    private Boolean taxExempt;
    private BigDecimal shippingAmount;
    private BigDecimal discountAmount;
    private String shipsFromPostalCode;
    private Transaction.Type type;
    private String venmoSdkPaymentMethodCode;
    private String paymentMethodNonce;
    private BigDecimal serviceFeeAmount;
    private String productSku;
    private String currencyIsoCode;
    private String threeDSecureToken;
    private Boolean threeDSecureTransaction = false;
    private String threeDSecureAuthenticationId;
    private String sharedPaymentMethodToken;
    private String sharedPaymentMethodNonce;
    private String sharedCustomerId;
    private String sharedShippingAddressId;
    private String sharedBillingAddressId;
    private RiskDataTransactionRequest riskDataTransactionRequest;
    private List<TransactionLineItemRequest> transactionLineItemRequests = new ArrayList<TransactionLineItemRequest>();
    private ExternalVaultRequest externalVaultRequest;
    private InstallmentRequest installments;

    public TransactionRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public TransactionAddressRequest billingAddress() {
        this.billingAddressRequest = new TransactionAddressRequest(this, "billing");
        return this.billingAddressRequest;
    }

    public TransactionRequest deviceData(String deviceData) {
        this.deviceData = deviceData;
        return this;
    }

    public TransactionRequest channel(String channel) {
        this.channel = channel;
        return this;
    }

    public TransactionCreditCardRequest creditCard() {
        this.creditCardRequest = new TransactionCreditCardRequest(this);
        return this.creditCardRequest;
    }

    public TransactionPayPalRequest paypalAccount() {
        this.paypalRequest = new TransactionPayPalRequest(this);
        return this.paypalRequest;
    }

    public TransactionRequest serviceFeeAmount(BigDecimal fee) {
        this.serviceFeeAmount = fee;
        return this;
    }

    public TransactionRequest productSku(String productSku) {
        this.productSku = productSku;
        return this;
    }

    public TransactionRequest currencyIsoCode(String currencyIsoCode) {
        this.currencyIsoCode = currencyIsoCode;
        return this;
    }

    public CustomerRequest customer() {
        this.customerRequest = new CustomerRequest(this);
        return this.customerRequest;
    }

    public TransactionRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public TransactionRequest customField(String apiName, String value) {
        this.customFields.put(apiName, value);
        return this;
    }

    public TransactionRequest scaExemption(Transaction.ScaExemption scaExemption) {
        this.scaExemption = scaExemption;
        return this;
    }

    @Deprecated
    public TransactionRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    @Deprecated
    public TransactionRequest fraudMerchantId(String fraudMerchantId) {
        this.fraudMerchantId = fraudMerchantId;
        return this;
    }

    public TransactionDescriptorRequest descriptor() {
        this.descriptorRequest = new TransactionDescriptorRequest(this);
        return this.descriptorRequest;
    }

    public TransactionRequest exchangeRateQuoteId(String exchangeRateQuoteId) {
        this.exchangeRateQuoteId = exchangeRateQuoteId;
        return this;
    }

    public TransactionIndustryRequest industry() {
        this.industryRequest = new TransactionIndustryRequest(this);
        return this.industryRequest;
    }

    public TransactionRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public TransactionOptionsRequest options() {
        this.transactionOptionsRequest = new TransactionOptionsRequest(this);
        return this.transactionOptionsRequest;
    }

    public TransactionThreeDSecurePassThruRequest threeDSecurePassThru() {
        this.threeDSecurePassThruRequest = new TransactionThreeDSecurePassThruRequest(this);
        return this.threeDSecurePassThruRequest;
    }

    public TransactionRequest orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public TransactionRequest paymentMethodToken(String paymentMethodToken) {
        this.paymentMethodToken = paymentMethodToken;
        return this;
    }

    public TransactionRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Deprecated
    public TransactionRequest recurring(Boolean recurring) {
        this.recurring = recurring;
        return this;
    }

    public TransactionRequest transactionSource(String source) {
        this.source = source;
        return this;
    }

    public TransactionAddressRequest shippingAddress() {
        this.shippingAddressRequest = new TransactionAddressRequest(this, "shipping");
        return this.shippingAddressRequest;
    }

    public TransactionRequest shippingAddressId(String shippingAddressId) {
        this.shippingAddressId = shippingAddressId;
        return this;
    }

    public TransactionRequest billingAddressId(String billingAddressId) {
        this.billingAddressId = billingAddressId;
        return this;
    }

    public TransactionRequest taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    public TransactionRequest taxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
        return this;
    }

    public TransactionRequest shippingAmount(BigDecimal shippingAmount) {
        this.shippingAmount = shippingAmount;
        return this;
    }

    public TransactionRequest discountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    public TransactionRequest shipsFromPostalCode(String shipsFromPostalCode) {
        this.shipsFromPostalCode = shipsFromPostalCode;
        return this;
    }

    public TransactionRequest venmoSdkPaymentMethodCode(String venmoSdkPaymentMethodCode) {
        this.venmoSdkPaymentMethodCode = venmoSdkPaymentMethodCode;
        return this;
    }

    public TransactionRequest paymentMethodNonce(String paymentMethodNonce) {
        this.paymentMethodNonce = paymentMethodNonce;
        return this;
    }

    public TransactionRequest threeDSecureToken(String threeDSecureToken) {
        this.threeDSecureTransaction = true;
        this.threeDSecureToken = threeDSecureToken;
        return this;
    }

    public TransactionRequest threeDSecureAuthenticationId(String threeDSecureAuthenticationId) {
        this.threeDSecureTransaction = true;
        this.threeDSecureAuthenticationId = threeDSecureAuthenticationId;
        return this;
    }

    public TransactionRequest sharedPaymentMethodToken(String sharedPaymentMethodToken) {
        this.sharedPaymentMethodToken = sharedPaymentMethodToken;
        return this;
    }

    public TransactionRequest sharedPaymentMethodNonce(String sharedPaymentMethodNonce) {
        this.sharedPaymentMethodNonce = sharedPaymentMethodNonce;
        return this;
    }

    public TransactionRequest sharedCustomerId(String sharedCustomerId) {
        this.sharedCustomerId = sharedCustomerId;
        return this;
    }

    public TransactionRequest sharedShippingAddressId(String sharedShippingAddressId) {
        this.sharedShippingAddressId = sharedShippingAddressId;
        return this;
    }

    public TransactionRequest sharedBillingAddressId(String sharedBillingAddressId) {
        this.sharedBillingAddressId = sharedBillingAddressId;
        return this;
    }

    public RiskDataTransactionRequest riskData() {
        this.riskDataTransactionRequest = new RiskDataTransactionRequest(this);
        return this.riskDataTransactionRequest;
    }

    public TransactionLineItemRequest lineItem() {
        TransactionLineItemRequest transactionLineItemRequest = new TransactionLineItemRequest(this);
        this.transactionLineItemRequests.add(transactionLineItemRequest);
        return transactionLineItemRequest;
    }

    public TransactionApplePayCardRequest applePayCardRequest() {
        TransactionApplePayCardRequest applePayCardRequest;
        this.applePayCardRequest = applePayCardRequest = new TransactionApplePayCardRequest(this);
        return applePayCardRequest;
    }

    public TransactionAndroidPayCardRequest androidPayCardRequest() {
        this.androidPayCardRequest = new TransactionAndroidPayCardRequest(this);
        return this.androidPayCardRequest;
    }

    public ExternalVaultRequest externalVault() {
        ExternalVaultRequest externalVaultRequest;
        this.externalVaultRequest = externalVaultRequest = new ExternalVaultRequest(this);
        return externalVaultRequest;
    }

    @Override
    public String toQueryString() {
        return this.toQueryString("transaction");
    }

    @Override
    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    @Override
    public String toXML() {
        return this.buildRequest("transaction").toXML();
    }

    public TransactionRequest type(Transaction.Type type) {
        this.type = type;
        return this;
    }

    public InstallmentRequest installments() {
        this.installments = new InstallmentRequest(this);
        return this.installments;
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root).addElement("amount", this.amount).addElement("deviceData", this.deviceData).addElement("channel", this.channel).addElement("customerId", this.customerId).addElement("exchangeRateQuoteId", this.exchangeRateQuoteId).addElement("merchantAccountId", this.merchantAccountId).addElement("orderId", this.orderId).addElement("paymentMethodToken", this.paymentMethodToken).addElement("paymentMethodNonce", this.paymentMethodNonce).addElement("purchaseOrderNumber", this.purchaseOrderNumber).addElement("taxAmount", this.taxAmount).addElement("taxExempt", this.taxExempt).addElement("shippingAmount", this.shippingAmount).addElement("discountAmount", this.discountAmount).addElement("shipsFromPostalCode", this.shipsFromPostalCode).addElement("shippingAddressId", this.shippingAddressId).addElement("billingAddressId", this.billingAddressId).addElement("creditCard", this.creditCardRequest).addElement("applePayCard", this.applePayCardRequest).addElement("androidPayCard", this.androidPayCardRequest).addElement("paypalAccount", this.paypalRequest).addElement("customer", this.customerRequest).addElement("descriptor", this.descriptorRequest).addElement("industry", this.industryRequest).addElement("billing", this.billingAddressRequest).addElement("shipping", this.shippingAddressRequest).addElement("options", this.transactionOptionsRequest).addElement("threeDSecurePassThru", this.threeDSecurePassThruRequest).addElement("recurring", this.recurring).addElement("transactionSource", this.source).addElement("deviceSessionId", this.deviceSessionId).addElement("fraudMerchantId", this.fraudMerchantId).addElement("venmoSdkPaymentMethodCode", this.venmoSdkPaymentMethodCode).addElement("sharedPaymentMethodToken", this.sharedPaymentMethodToken).addElement("sharedPaymentMethodNonce", this.sharedPaymentMethodNonce).addElement("sharedCustomerId", this.sharedCustomerId).addElement("sharedShippingAddressId", this.sharedShippingAddressId).addElement("sharedBillingAddressId", this.sharedBillingAddressId).addElement("serviceFeeAmount", this.serviceFeeAmount).addElement("productSku", this.productSku).addElement("riskData", this.riskDataTransactionRequest).addElement("externalVault", this.externalVaultRequest).addElement("currencyIsoCode", this.currencyIsoCode).addElement("installments", this.installments);
        if (!this.customFields.isEmpty()) {
            builder.addElement("customFields", this.customFields);
        }
        if (this.type != null) {
            builder.addElement("type", this.type.toString().toLowerCase());
        }
        if (this.scaExemption != null) {
            builder.addElement("scaExemption", this.scaExemption.toString());
        }
        if (this.threeDSecureTransaction.booleanValue()) {
            if (this.threeDSecureAuthenticationId != null) {
                builder.addElement("threeDSecureAuthenticationId", this.threeDSecureAuthenticationId);
            } else {
                String token = this.threeDSecureToken != null ? this.threeDSecureToken : "";
                builder.addElement("threeDSecureToken", token);
            }
        }
        if (!this.transactionLineItemRequests.isEmpty()) {
            builder.addElement("lineItems", this.transactionLineItemRequests);
        }
        return builder;
    }
}

