/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaginatedResult;
import com.braintreegateway.SimplePager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginatedCollection<T>
implements Iterable<T> {
    private SimplePager<T> pager;
    private int pageSize;

    public PaginatedCollection(SimplePager<T> pager) {
        this.pager = pager;
    }

    @Override
    public Iterator<T> iterator() {
        return new PagedIterator(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PagedIterator<E>
    implements Iterator<E> {
        private PaginatedCollection<E> paginatedCollection;
        private int pageSize;
        private int currentPage;
        private int index;
        private int totalSize;
        private List<E> items;

        public PagedIterator(PaginatedCollection<E> paginatedCollection2) {
            this.paginatedCollection = paginatedCollection2;
            this.pageSize = 0;
            this.currentPage = 0;
            this.index = 0;
            this.totalSize = 0;
            this.items = new ArrayList();
        }

        @Override
        public boolean hasNext() {
            if (this.currentPage == 0 || this.index % this.pageSize == 0 && this.index < this.totalSize) {
                ++this.currentPage;
                PaginatedResult results = ((PaginatedCollection)this.paginatedCollection).pager.getPage(this.currentPage);
                this.totalSize = results.getTotalItems();
                this.items = results.getCurrentPage();
                this.pageSize = results.getPageSize();
            }
            return this.index < this.totalSize;
        }

        @Override
        public E next() {
            E item = this.items.get(this.index % this.pageSize);
            ++this.index;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

