/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmexExpressCheckoutCard
implements PaymentMethod {
    private String cardType;
    private String token;
    private String bin;
    private String expirationMonth;
    private String expirationYear;
    private String cardMemberNumber;
    private String cardMemberExpiryDate;
    private String sourceDescription;
    private Boolean isDefault;
    private String imageUrl;
    private String customerId;
    private Calendar createdAt;
    private Calendar updatedAt;
    private List<Subscription> subscriptions;

    public AmexExpressCheckoutCard(NodeWrapper node) {
        this.bin = node.findString("bin");
        this.cardMemberExpiryDate = node.findString("card-member-expiry-date");
        this.cardMemberNumber = node.findString("card-member-number");
        this.cardType = node.findString("card-type");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.sourceDescription = node.findString("source-description");
        this.token = node.findString("token");
        this.isDefault = node.findBoolean("default");
        this.imageUrl = node.findString("image-url");
        this.customerId = node.findString("customer-id");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
    }

    public String getBin() {
        return this.bin;
    }

    public String getCardMemberExpiryDate() {
        return this.cardMemberExpiryDate;
    }

    public String getCardMemberNumber() {
        return this.cardMemberNumber;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }
}

