/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;

public class TransactionLineItem {
    private BigDecimal quantity;
    private String name;
    private String description;
    private Kind kind;
    private BigDecimal unitAmount;
    private BigDecimal unitTaxAmount;
    private BigDecimal totalAmount;
    private BigDecimal discountAmount;
    private String unitOfMeasure;
    private String productCode;
    private String commodityCode;
    private String url;

    public TransactionLineItem(NodeWrapper node) {
        this.quantity = node.findBigDecimal("quantity");
        this.name = node.findString("name");
        this.description = node.findString("description");
        this.kind = EnumUtils.findByName(Kind.class, node.findString("kind"), Kind.UNRECOGNIZED);
        this.unitAmount = node.findBigDecimal("unit-amount");
        this.unitTaxAmount = node.findBigDecimal("unit-tax-amount");
        this.totalAmount = node.findBigDecimal("total-amount");
        this.discountAmount = node.findBigDecimal("discount-amount");
        this.unitOfMeasure = node.findString("unit-of-measure");
        this.productCode = node.findString("product-code");
        this.commodityCode = node.findString("commodity-code");
        this.url = node.findString("url");
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Kind getKind() {
        return this.kind;
    }

    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public BigDecimal getUnitTaxAmount() {
        return this.unitTaxAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getCommodityCode() {
        return this.commodityCode;
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        DEBIT("debit"),
        CREDIT("credit"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

