/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AmexExpressCheckoutCard;
import com.braintreegateway.AndroidPayCard;
import com.braintreegateway.ApplePayCard;
import com.braintreegateway.CoinbaseAccount;
import com.braintreegateway.Configuration;
import com.braintreegateway.CreditCard;
import com.braintreegateway.EuropeBankAccount;
import com.braintreegateway.MasterpassCard;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.PaymentMethodDeleteRequest;
import com.braintreegateway.PaymentMethodGrantRequest;
import com.braintreegateway.PaymentMethodGrantRevokeRequest;
import com.braintreegateway.PaymentMethodNonce;
import com.braintreegateway.PaymentMethodRequest;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.Result;
import com.braintreegateway.UnknownPaymentMethod;
import com.braintreegateway.UsBankAccount;
import com.braintreegateway.VenmoAccount;
import com.braintreegateway.VisaCheckoutCard;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethodGateway {
    private Http http;
    private Configuration configuration;

    public PaymentMethodGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<? extends PaymentMethod> create(PaymentMethodRequest request) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods", request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> update(String token, PaymentMethodRequest request) {
        NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/payment_methods/any/" + token, request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> delete(String token) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/any/" + token);
        return new Result();
    }

    public Result<? extends PaymentMethod> delete(String token, PaymentMethodDeleteRequest request) {
        this.http.delete(this.configuration.getMerchantPath() + "/payment_methods/any/" + token + "?" + request.toQueryString());
        return new Result();
    }

    public PaymentMethod find(String token) {
        if (token == null || token.trim().equals("")) {
            throw new NotFoundException();
        }
        NodeWrapper response = this.http.get(this.configuration.getMerchantPath() + "/payment_methods/any/" + token);
        return this.parseResponse(response).getTarget();
    }

    public Result<PaymentMethodNonce> grant(String token) {
        String request = new RequestBuilder("payment-method").addElement("shared-payment-method-token", token).toXML();
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/grant", request);
        return new Result<PaymentMethodNonce>(response, PaymentMethodNonce.class);
    }

    public Result<PaymentMethodNonce> grant(String token, PaymentMethodGrantRequest grantRequest) {
        String request = grantRequest.sharedPaymentMethodToken(token).toXML();
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/grant", request);
        return new Result<PaymentMethodNonce>(response, PaymentMethodNonce.class);
    }

    public Result<? extends PaymentMethod> revoke(String token) {
        PaymentMethodGrantRevokeRequest revokeRequest = new PaymentMethodGrantRevokeRequest();
        String request = revokeRequest.sharedPaymentMethodToken(token).toXML();
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/revoke", request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> parseResponse(NodeWrapper response) {
        if (response.getElementName() == "paypal-account") {
            return new Result<PayPalAccount>(response, PayPalAccount.class);
        }
        if (response.getElementName() == "credit-card") {
            return new Result<CreditCard>(response, CreditCard.class);
        }
        if (response.getElementName() == "europe-bank-account") {
            return new Result<EuropeBankAccount>(response, EuropeBankAccount.class);
        }
        if (response.getElementName() == "apple-pay-card") {
            return new Result<ApplePayCard>(response, ApplePayCard.class);
        }
        if (response.getElementName() == "android-pay-card") {
            return new Result<AndroidPayCard>(response, AndroidPayCard.class);
        }
        if (response.getElementName() == "amex-express-checkout-card") {
            return new Result<AmexExpressCheckoutCard>(response, AmexExpressCheckoutCard.class);
        }
        if (response.getElementName() == "coinbase-account") {
            return new Result<CoinbaseAccount>(response, CoinbaseAccount.class);
        }
        if (response.getElementName() == "us-bank-account") {
            return new Result<UsBankAccount>(response, UsBankAccount.class);
        }
        if (response.getElementName() == "venmo-account") {
            return new Result<VenmoAccount>(response, VenmoAccount.class);
        }
        if (response.getElementName() == "visa-checkout-card") {
            return new Result<VisaCheckoutCard>(response, VisaCheckoutCard.class);
        }
        if (response.getElementName() == "masterpass-card") {
            return new Result<MasterpassCard>(response, MasterpassCard.class);
        }
        return new Result<UnknownPaymentMethod>(response, UnknownPaymentMethod.class);
    }
}

