/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Subscription;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public class SubscriptionStatusEvent {
    private BigDecimal balance;
    private String currencyIsoCode;
    private BigDecimal price;
    private Calendar timestamp;
    private Subscription.Source source;
    private Subscription.Status status;
    private String user;

    public SubscriptionStatusEvent(NodeWrapper node) {
        this.balance = node.findBigDecimal("balance");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.price = node.findBigDecimal("price");
        this.source = EnumUtils.findByName(Subscription.Source.class, node.findString("subscription-source"), Subscription.Source.UNRECOGNIZED);
        this.status = EnumUtils.findByName(Subscription.Status.class, node.findString("status"), Subscription.Status.UNRECOGNIZED);
        this.timestamp = node.findDateTime("timestamp");
        this.user = node.findString("user");
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Subscription.Status getStatus() {
        return this.status;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public Subscription.Source getSource() {
        return this.source;
    }

    public String getUser() {
        return this.user;
    }
}

