/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.Configuration;
import com.braintreegateway.Request;
import com.braintreegateway.exceptions.AuthenticationException;
import com.braintreegateway.exceptions.AuthorizationException;
import com.braintreegateway.exceptions.DownForMaintenanceException;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.exceptions.ServerException;
import com.braintreegateway.exceptions.UnexpectedException;
import com.braintreegateway.exceptions.UpgradeRequiredException;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.NodeWrapperFactory;
import com.braintreegateway.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class Http {
    private Configuration configuration;

    public Http(Configuration configuration) {
        this.configuration = configuration;
    }

    public void delete(String url) {
        this.httpRequest(RequestMethod.DELETE, url);
    }

    public NodeWrapper get(String url) {
        return this.httpRequest(RequestMethod.GET, url);
    }

    public NodeWrapper post(String url) {
        return this.httpRequest(RequestMethod.POST, url, null);
    }

    public NodeWrapper post(String url, Request request) {
        return this.httpRequest(RequestMethod.POST, url, request.toXML());
    }

    public NodeWrapper put(String url) {
        return this.httpRequest(RequestMethod.PUT, url, null);
    }

    public NodeWrapper put(String url, Request request) {
        return this.httpRequest(RequestMethod.PUT, url, request.toXML());
    }

    private NodeWrapper httpRequest(RequestMethod requestMethod, String url) {
        return this.httpRequest(requestMethod, url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeWrapper httpRequest(RequestMethod requestMethod, String url, String postBody) {
        HttpURLConnection connection = null;
        NodeWrapper nodeWrapper = null;
        try {
            OutputStream outputStream;
            connection = this.buildConnection(requestMethod, url);
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.getSSLSocketFactory());
            }
            if (postBody != null) {
                outputStream = null;
                try {
                    outputStream = connection.getOutputStream();
                    outputStream.write(postBody.getBytes("UTF-8"));
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            Http.throwExceptionIfErrorStatusCode(connection.getResponseCode(), null);
            if (requestMethod.equals((Object)RequestMethod.DELETE)) {
                outputStream = null;
                return outputStream;
            }
            InputStream responseStream = null;
            try {
                InputStream inputStream = responseStream = connection.getResponseCode() == 422 ? connection.getErrorStream() : connection.getInputStream();
                if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                    responseStream = new GZIPInputStream(responseStream);
                }
                String xml = StringUtils.inputStreamToString(responseStream);
                nodeWrapper = NodeWrapperFactory.instance.create(xml);
            }
            finally {
                if (responseStream != null) {
                    responseStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return nodeWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSSLSocketFactory() {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            for (String certificateFilename : this.configuration.getEnvironment().certificateFilenames) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                InputStream certStream = null;
                try {
                    certStream = Http.class.getClassLoader().getResourceAsStream(certificateFilename);
                    Collection<? extends Certificate> coll = cf.generateCertificates(certStream);
                    for (Certificate certificate : coll) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        X509Certificate x509cert = (X509Certificate)certificate;
                        Principal principal = x509cert.getSubjectDN();
                        String subject = principal.getName();
                        keyStore.setCertificateEntry(subject, certificate);
                    }
                }
                finally {
                    if (certStream != null) {
                        certStream.close();
                    }
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG"));
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }

    private HttpURLConnection buildConnection(RequestMethod requestMethod, String urlString) throws IOException {
        URL url = new URL(this.configuration.getBaseURL() + urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMethod.toString());
        connection.addRequestProperty("Accept", "application/xml");
        connection.addRequestProperty("User-Agent", "Braintree Java " + Configuration.VERSION);
        connection.addRequestProperty("X-ApiVersion", Configuration.apiVersion());
        connection.addRequestProperty("Authorization", this.authorizationHeader());
        connection.addRequestProperty("Accept-Encoding", "gzip");
        connection.addRequestProperty("Content-Type", "application/xml");
        connection.setDoOutput(true);
        connection.setReadTimeout(60000);
        return connection;
    }

    public static void throwExceptionIfErrorStatusCode(int statusCode, String message) {
        String decodedMessage = null;
        if (message != null) {
            try {
                decodedMessage = URLDecoder.decode(message, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (Http.isErrorCode(statusCode)) {
            switch (statusCode) {
                case 401: {
                    throw new AuthenticationException();
                }
                case 403: {
                    throw new AuthorizationException(decodedMessage);
                }
                case 404: {
                    throw new NotFoundException();
                }
                case 426: {
                    throw new UpgradeRequiredException();
                }
                case 500: {
                    throw new ServerException();
                }
                case 503: {
                    throw new DownForMaintenanceException();
                }
            }
            throw new UnexpectedException("Unexpected HTTP_RESPONSE " + statusCode);
        }
    }

    private static boolean isErrorCode(int responseCode) {
        return responseCode != 200 && responseCode != 201 && responseCode != 422;
    }

    public String authorizationHeader() {
        if (this.configuration.isAccessToken().booleanValue()) {
            return "Bearer " + this.configuration.getAccessToken();
        }
        String credentials = this.configuration.isClientCredentials() != false ? this.configuration.getClientId() + ":" + this.configuration.getClientSecret() : this.configuration.getPublicKey() + ":" + this.configuration.getPrivateKey();
        return "Basic " + Base64.encodeBase64String(credentials.getBytes()).trim();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestMethod {
        DELETE,
        GET,
        POST,
        PUT;

    }
}

