/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public final class DisbursementDetails {
    private final Calendar disbursementDate;
    private final String settlementCurrencyIsoCode;
    private final boolean fundsHeld;
    private final boolean success;
    private final BigDecimal settlementCurrencyExchangeRate;
    private final BigDecimal settlementAmount;

    public DisbursementDetails(NodeWrapper node) {
        this.disbursementDate = node.findDate("disbursement-date");
        this.settlementCurrencyIsoCode = node.findString("settlement-currency-iso-code");
        this.fundsHeld = node.findBoolean("funds-held");
        this.success = node.findBoolean("success");
        this.settlementCurrencyExchangeRate = node.findBigDecimal("settlement-currency-exchange-rate");
        this.settlementAmount = node.findBigDecimal("settlement-amount");
    }

    public Calendar getDisbursementDate() {
        return this.disbursementDate;
    }

    public String getSettlementCurrencyIsoCode() {
        return this.settlementCurrencyIsoCode;
    }

    public boolean isFundsHeld() {
        return this.fundsHeld;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public BigDecimal getSettlementCurrencyExchangeRate() {
        return this.settlementCurrencyExchangeRate;
    }

    public BigDecimal getSettlementAmount() {
        return this.settlementAmount;
    }

    public boolean isValid() {
        return this.getDisbursementDate() != null;
    }
}

