/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.ClientTokenRequest;
import com.braintreegateway.Configuration;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.StringUtils;
import java.util.ArrayList;

public class ClientTokenGateway {
    private Http http;
    private Configuration configuration;

    public ClientTokenGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public String generate() {
        return this.generate(new ClientTokenRequest());
    }

    public String generate(ClientTokenRequest request) {
        NodeWrapper response = null;
        this.verifyOptions(request);
        response = this.http.post("/client_token", request);
        String token = response.findString("value");
        if (token != null) {
            token = StringUtils.unescapeUtf8(token);
        }
        return token;
    }

    private void verifyOptions(ClientTokenRequest request) {
        if (request.getCustomerId() != null || request.getOptions() == null) {
            return;
        }
        ArrayList<String> invalidOptions = new ArrayList<String>();
        if (request.getOptions().getMakeDefault() != null) {
            invalidOptions.add("makeDefault");
        }
        if (request.getOptions().getVerifyCard() != null) {
            invalidOptions.add("verifyCard");
        }
        if (request.getOptions().getFailOnDuplicatePaymentMethod() != null) {
            invalidOptions.add("failOnDuplicatePaymentMethod");
        }
        if (invalidOptions.size() != 0) {
            String message = "Following arguments are invalid without customerId:";
            for (String optionName : invalidOptions) {
                message = message + " " + optionName;
            }
            throw new IllegalArgumentException(message);
        }
    }
}

