/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.MerchantAccount;
import com.braintreegateway.MerchantAccountRequest;
import com.braintreegateway.Result;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MerchantAccountGateway {
    public static final String CREATE_URL = "/merchant_accounts/create_via_api";
    private final Http http;

    public MerchantAccountGateway(Http http) {
        this.http = http;
    }

    public Result<MerchantAccount> create(MerchantAccountRequest request) {
        NodeWrapper response = this.http.post(CREATE_URL, request);
        return new Result<MerchantAccount>(response, MerchantAccount.class);
    }

    public MerchantAccount find(String id) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new MerchantAccount(this.http.get("/merchant_accounts/" + id));
    }

    public Result<MerchantAccount> update(String id, MerchantAccountRequest request) {
        NodeWrapper response = this.http.put("/merchant_accounts/" + id + "/update_via_api", request);
        return new Result<MerchantAccount>(response, MerchantAccount.class);
    }
}

