/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AddOn;
import com.braintreegateway.Descriptor;
import com.braintreegateway.Discount;
import com.braintreegateway.Transaction;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription {
    private ArrayList<AddOn> addOns = new ArrayList();
    private BigDecimal balance;
    private Integer billingDayOfMonth;
    private Calendar billingPeriodEndDate;
    private Calendar billingPeriodStartDate;
    private Integer currentBillingCycle;
    private Integer daysPastDue;
    private Descriptor descriptor;
    private ArrayList<Discount> discounts;
    private Integer failureCount;
    private Calendar createdAt;
    private Calendar updatedAt;
    private Calendar firstBillingDate;
    private Boolean hasTrialPeriod;
    private String id;
    private String merchantAccountId;
    private boolean neverExpires;
    private BigDecimal nextBillAmount;
    private Calendar nextBillingDate;
    private BigDecimal nextBillingPeriodAmount;
    private Integer numberOfBillingCycles;
    private Calendar paidThroughDate;
    private String paymentMethodToken;
    private String planId;
    private BigDecimal price;
    private Status status;
    private List<Transaction> transactions;
    private Integer trialDuration;
    private DurationUnit trialDurationUnit;

    public Subscription(NodeWrapper node) {
        for (NodeWrapper addOnResponse : node.findAll("add-ons/add-on")) {
            this.addOns.add(new AddOn(addOnResponse));
        }
        this.balance = node.findBigDecimal("balance");
        this.billingDayOfMonth = node.findInteger("billing-day-of-month");
        this.billingPeriodEndDate = node.findDate("billing-period-end-date");
        this.billingPeriodStartDate = node.findDate("billing-period-start-date");
        this.currentBillingCycle = node.findInteger("current-billing-cycle");
        this.daysPastDue = node.findInteger("days-past-due");
        if (node.findFirst("descriptor") != null) {
            this.descriptor = new Descriptor(node.findFirst("descriptor"));
        }
        this.discounts = new ArrayList();
        for (NodeWrapper discountResponse : node.findAll("discounts/discount")) {
            this.discounts.add(new Discount(discountResponse));
        }
        this.failureCount = node.findInteger("failure-count");
        this.firstBillingDate = node.findDate("first-billing-date");
        this.id = node.findString("id");
        this.merchantAccountId = node.findString("merchant-account-id");
        this.neverExpires = node.findBoolean("never-expires");
        this.nextBillAmount = node.findBigDecimal("next-bill-amount");
        this.nextBillingDate = node.findDate("next-billing-date");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.nextBillingPeriodAmount = node.findBigDecimal("next-billing-period-amount");
        this.numberOfBillingCycles = node.findInteger("number-of-billing-cycles");
        this.paidThroughDate = node.findDate("paid-through-date");
        this.paymentMethodToken = node.findString("payment-method-token");
        this.planId = node.findString("plan-id");
        this.price = node.findBigDecimal("price");
        this.status = EnumUtils.findByName(Status.class, node.findString("status"));
        this.hasTrialPeriod = node.findBoolean("trial-period");
        this.trialDuration = node.findInteger("trial-duration");
        this.trialDurationUnit = EnumUtils.findByName(DurationUnit.class, node.findString("trial-duration-unit"));
        this.transactions = new ArrayList<Transaction>();
        for (NodeWrapper transactionResponse : node.findAll("transactions/transaction")) {
            this.transactions.add(new Transaction(transactionResponse));
        }
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public Integer getBillingDayOfMonth() {
        return this.billingDayOfMonth;
    }

    public Calendar getBillingPeriodEndDate() {
        return this.billingPeriodEndDate;
    }

    public Calendar getBillingPeriodStartDate() {
        return this.billingPeriodStartDate;
    }

    public Integer getCurrentBillingCycle() {
        return this.currentBillingCycle;
    }

    public Integer getDaysPastDue() {
        return this.daysPastDue;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public Calendar getFirstBillingDate() {
        return this.firstBillingDate;
    }

    public String getId() {
        return this.id;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    @Deprecated
    public BigDecimal getNextBillAmount() {
        return this.nextBillAmount;
    }

    public Calendar getNextBillingDate() {
        return this.nextBillingDate;
    }

    public BigDecimal getNextBillingPeriodAmount() {
        return this.nextBillingPeriodAmount;
    }

    public Integer getNumberOfBillingCycles() {
        return this.numberOfBillingCycles;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public Calendar getPaidThroughDate() {
        return this.paidThroughDate;
    }

    public String getPaymentMethodToken() {
        return this.paymentMethodToken;
    }

    public String getPlanId() {
        return this.planId;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Integer getTrialDuration() {
        return this.trialDuration;
    }

    public DurationUnit getTrialDurationUnit() {
        return this.trialDurationUnit;
    }

    public Boolean hasTrialPeriod() {
        return this.hasTrialPeriod;
    }

    public boolean neverExpires() {
        return this.neverExpires;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Subscription)) {
            return false;
        }
        return this.getId().equals(((Subscription)other).getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ACTIVE("Active"),
        CANCELED("Canceled"),
        EXPIRED("Expired"),
        PAST_DUE("Past Due"),
        PENDING("Pending"),
        UNRECOGNIZED("Unrecognized");

        private final String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DurationUnit {
        DAY,
        MONTH,
        UNRECOGNIZED;

    }
}

