/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CustomerRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionAddressRequest;
import com.braintreegateway.TransactionCreditCardRequest;
import com.braintreegateway.TransactionDescriptorRequest;
import com.braintreegateway.TransactionOptionsRequest;
import com.braintreegateway.TransactionPayPalRequest;
import com.braintreegateway.TransparentRedirectGateway;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class TransactionRequest
extends Request {
    private BigDecimal amount;
    private TransactionAddressRequest billingAddressRequest;
    private String deviceData;
    private TransactionCreditCardRequest creditCardRequest;
    private TransactionPayPalRequest paypalRequest;
    private String channel;
    private String customerId;
    private String deviceSessionId;
    private String fraudMerchantId;
    private CustomerRequest customerRequest;
    private Map<String, String> customFields = new HashMap<String, String>();
    private String merchantAccountId;
    private String orderId;
    private String paymentMethodToken;
    private String purchaseOrderNumber;
    private Boolean recurring;
    private String shippingAddressId;
    private String billingAddressId;
    private TransactionDescriptorRequest descriptorRequest;
    private TransactionAddressRequest shippingAddressRequest;
    private TransactionOptionsRequest transactionOptionsRequest;
    private BigDecimal taxAmount;
    private Boolean taxExempt;
    private Transaction.Type type;
    private String venmoSdkPaymentMethodCode;
    private String paymentMethodNonce;
    private BigDecimal serviceFeeAmount;
    private String threeDSecureToken;
    private Boolean threeDSecureTransaction = false;

    public TransactionRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    public TransactionAddressRequest billingAddress() {
        this.billingAddressRequest = new TransactionAddressRequest(this, "billing");
        return this.billingAddressRequest;
    }

    public TransactionRequest deviceData(String deviceData) {
        this.deviceData = deviceData;
        return this;
    }

    public TransactionRequest channel(String channel) {
        this.channel = channel;
        return this;
    }

    public TransactionCreditCardRequest creditCard() {
        this.creditCardRequest = new TransactionCreditCardRequest(this);
        return this.creditCardRequest;
    }

    public TransactionPayPalRequest paypalAccount() {
        this.paypalRequest = new TransactionPayPalRequest(this);
        return this.paypalRequest;
    }

    public TransactionRequest serviceFeeAmount(BigDecimal fee) {
        this.serviceFeeAmount = fee;
        return this;
    }

    public CustomerRequest customer() {
        this.customerRequest = new CustomerRequest(this);
        return this.customerRequest;
    }

    public TransactionRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public TransactionRequest customField(String apiName, String value) {
        this.customFields.put(apiName, value);
        return this;
    }

    public TransactionRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    public TransactionRequest fraudMerchantId(String fraudMerchantId) {
        this.fraudMerchantId = fraudMerchantId;
        return this;
    }

    public TransactionDescriptorRequest descriptor() {
        this.descriptorRequest = new TransactionDescriptorRequest(this);
        return this.descriptorRequest;
    }

    public String getKind() {
        return TransparentRedirectGateway.CREATE_TRANSACTION;
    }

    public TransactionRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public TransactionOptionsRequest options() {
        this.transactionOptionsRequest = new TransactionOptionsRequest(this);
        return this.transactionOptionsRequest;
    }

    public TransactionRequest orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public TransactionRequest paymentMethodToken(String paymentMethodToken) {
        this.paymentMethodToken = paymentMethodToken;
        return this;
    }

    public TransactionRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    public TransactionRequest recurring(Boolean recurring) {
        this.recurring = recurring;
        return this;
    }

    public TransactionAddressRequest shippingAddress() {
        this.shippingAddressRequest = new TransactionAddressRequest(this, "shipping");
        return this.shippingAddressRequest;
    }

    public TransactionRequest shippingAddressId(String shippingAddressId) {
        this.shippingAddressId = shippingAddressId;
        return this;
    }

    public TransactionRequest billingAddressId(String billingAddressId) {
        this.billingAddressId = billingAddressId;
        return this;
    }

    public TransactionRequest taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    public TransactionRequest taxExempt(Boolean taxExempt) {
        this.taxExempt = taxExempt;
        return this;
    }

    public TransactionRequest venmoSdkPaymentMethodCode(String venmoSdkPaymentMethodCode) {
        this.venmoSdkPaymentMethodCode = venmoSdkPaymentMethodCode;
        return this;
    }

    public TransactionRequest paymentMethodNonce(String paymentMethodNonce) {
        this.paymentMethodNonce = paymentMethodNonce;
        return this;
    }

    public TransactionRequest threeDSecureToken(String threeDSecureToken) {
        this.threeDSecureTransaction = true;
        this.threeDSecureToken = threeDSecureToken;
        return this;
    }

    public String toQueryString() {
        return this.toQueryString("transaction");
    }

    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    public String toXML() {
        return this.buildRequest("transaction").toXML();
    }

    public TransactionRequest type(Transaction.Type type) {
        this.type = type;
        return this;
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root).addElement("amount", this.amount).addElement("deviceData", this.deviceData).addElement("channel", this.channel).addElement("customerId", this.customerId).addElement("merchantAccountId", this.merchantAccountId).addElement("orderId", this.orderId).addElement("paymentMethodToken", this.paymentMethodToken).addElement("paymentMethodNonce", this.paymentMethodNonce).addElement("purchaseOrderNumber", this.purchaseOrderNumber).addElement("taxAmount", this.taxAmount).addElement("taxExempt", this.taxExempt).addElement("shippingAddressId", this.shippingAddressId).addElement("billingAddressId", this.billingAddressId).addElement("creditCard", this.creditCardRequest).addElement("paypalAccount", this.paypalRequest).addElement("customer", this.customerRequest).addElement("descriptor", this.descriptorRequest).addElement("billing", this.billingAddressRequest).addElement("shipping", this.shippingAddressRequest).addElement("options", this.transactionOptionsRequest).addElement("recurring", this.recurring).addElement("deviceSessionId", this.deviceSessionId).addElement("fraudMerchantId", this.fraudMerchantId).addElement("venmoSdkPaymentMethodCode", this.venmoSdkPaymentMethodCode).addElement("serviceFeeAmount", this.serviceFeeAmount);
        if (!this.customFields.isEmpty()) {
            builder.addElement("customFields", this.customFields);
        }
        if (this.type != null) {
            builder.addElement("type", this.type.toString().toLowerCase());
        }
        if (this.threeDSecureTransaction.booleanValue()) {
            String token = this.threeDSecureToken != null ? this.threeDSecureToken : "";
            builder.addElement("threeDSecureToken", token);
        }
        return builder;
    }
}

