/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.WebhookNotification;
import com.braintreegateway.exceptions.InvalidSignatureException;
import com.braintreegateway.org.apache.commons.codec.binary.Base64;
import com.braintreegateway.util.Crypto;
import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.NodeWrapperFactory;

public class WebhookNotificationGateway {
    private Configuration configuration;

    public WebhookNotificationGateway(Configuration configuration) {
        this.configuration = configuration;
    }

    public WebhookNotification parse(String signature, String payload) {
        this.validateSignature(signature, payload);
        String xmlPayload = new String(Base64.decodeBase64(payload));
        NodeWrapper node = NodeWrapperFactory.instance.create(xmlPayload);
        return new WebhookNotification(node);
    }

    private void validateSignature(String signature, String payload) {
        String computedSignature;
        Crypto crypto;
        String[] signaturePairs;
        String matchingSignature = null;
        for (String signaturePair : signaturePairs = signature.split("&")) {
            String[] candidatePair;
            if (signaturePair.indexOf("|") < 0 || !this.configuration.publicKey.equals((candidatePair = signaturePair.split("\\|"))[0])) continue;
            matchingSignature = candidatePair[1];
            break;
        }
        if (!(crypto = new Crypto()).secureCompare(computedSignature = crypto.hmacHash(this.configuration.privateKey, payload), matchingSignature).booleanValue()) {
            throw new InvalidSignatureException();
        }
    }

    public String verify(String challenge) {
        return this.publicKeySignaturePair(challenge);
    }

    private String publicKeySignaturePair(String stringToSign) {
        return String.format("%s|%s", this.configuration.publicKey, new Crypto().hmacHash(this.configuration.privateKey, stringToSign));
    }
}

