/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AddOn;
import com.braintreegateway.Discount;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plan {
    private String id;
    private List<AddOn> addOns;
    private String merchantId;
    private Integer billingDayOfMonth;
    private Integer billingFrequency;
    private String currencyIsoCode;
    private String description;
    private List<Discount> discounts;
    private String name;
    private Integer numberOfBillingCycles;
    private BigDecimal price;
    private Boolean trialPeriod;
    private Integer trialDuration;
    private DurationUnit trialDurationUnit;
    private Calendar createdAt;
    private Calendar updatedAt;

    public Plan(NodeWrapper node) {
        this.id = node.findString("id");
        this.addOns = new ArrayList<AddOn>();
        for (NodeWrapper addOnResponse : node.findAll("add-ons/add-on")) {
            this.addOns.add(new AddOn(addOnResponse));
        }
        this.merchantId = node.findString("merchant-id");
        this.billingDayOfMonth = node.findInteger("billing-day-of-month");
        this.billingFrequency = node.findInteger("billing-frequency");
        this.createdAt = node.findDateTime("created-at");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.description = node.findString("description");
        this.discounts = new ArrayList<Discount>();
        for (NodeWrapper discountResponse : node.findAll("discounts/discount")) {
            this.discounts.add(new Discount(discountResponse));
        }
        this.name = node.findString("name");
        this.numberOfBillingCycles = node.findInteger("number-of-billing-cycles");
        this.price = node.findBigDecimal("price");
        this.trialPeriod = node.findBoolean("trial-period");
        this.trialDuration = node.findInteger("trial-duration");
        this.trialDurationUnit = EnumUtils.findByName(DurationUnit.class, node.findString("trial-duration-unit"));
        this.updatedAt = node.findDateTime("updated-at");
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public Integer getBillingFrequency() {
        return this.billingFrequency;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    public String getId() {
        return this.id;
    }

    public Integer getNumberOfBillingCycles() {
        return this.numberOfBillingCycles;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public Boolean hasTrialPeriod() {
        return this.trialPeriod;
    }

    public Integer getTrialDuration() {
        return this.trialDuration;
    }

    public DurationUnit getTrialDurationUnit() {
        return this.trialDurationUnit;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public Integer getBillingDayOfMonth() {
        return this.billingDayOfMonth;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DurationUnit {
        DAY,
        MONTH,
        UNRECOGNIZED;

    }
}

