/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Request;
import com.braintreegateway.util.QueryString;
import com.braintreegateway.util.StringUtils;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestBuilder {
    private String parent;
    private Map<String, String> topLevelElements;
    private Map<String, Object> elements;

    public RequestBuilder(String parent) {
        this.parent = parent;
        this.topLevelElements = new HashMap<String, String>();
        this.elements = new HashMap<String, Object>();
    }

    public RequestBuilder addTopLevelElement(String name, String value) {
        this.topLevelElements.put(name, value);
        return this;
    }

    public RequestBuilder addElement(String name, Object value) {
        this.elements.put(name, value);
        return this;
    }

    public String toQueryString() {
        QueryString queryString = new QueryString();
        for (Map.Entry<String, String> entry : this.topLevelElements.entrySet()) {
            queryString.append(StringUtils.underscore(entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
            queryString.append(RequestBuilder.parentBracketChildString(StringUtils.underscore(this.parent), StringUtils.underscore(entry.getKey())), entry.getValue());
        }
        return queryString.toString();
    }

    public String toXML() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("<%s>", this.parent));
        for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
            builder.append(RequestBuilder.buildXMLElement(entry.getKey(), entry.getValue()));
        }
        builder.append(String.format("</%s>", this.parent));
        return builder.toString();
    }

    protected static String buildXMLElement(Object element) {
        return RequestBuilder.buildXMLElement("", element);
    }

    protected static String buildXMLElement(String name, Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof Request) {
            return ((Request)element).toXML();
        }
        if (element instanceof Calendar) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return String.format("<%s type=\"datetime\">%s</%s>", name, dateFormat.format(((Calendar)element).getTime()), name);
        }
        if (element instanceof Map) {
            return RequestBuilder.formatAsXML(name, (Map)element);
        }
        if (element instanceof List) {
            StringBuilder xml = new StringBuilder();
            for (Object item : (List)element) {
                xml.append(RequestBuilder.buildXMLElement("item", item));
            }
            return RequestBuilder.wrapInXMLTag(name, xml.toString(), "array");
        }
        return String.format("<%s>%s</%s>", RequestBuilder.xmlEscape(name), element == null ? "" : RequestBuilder.xmlEscape(element.toString()), RequestBuilder.xmlEscape(name));
    }

    protected static String formatAsXML(String name, Map<String, Object> map) {
        if (map == null) {
            return "";
        }
        StringBuilder xml = new StringBuilder();
        xml.append(String.format("<%s>", name));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            xml.append(RequestBuilder.buildXMLElement(entry.getKey(), entry.getValue()));
        }
        xml.append(String.format("</%s>", name));
        return xml.toString();
    }

    protected static Object buildQueryStringElement(String name, String value) {
        if (value != null) {
            try {
                return String.format("%s=%s&", URLEncoder.encode(name, "UTF-8"), URLEncoder.encode(value, "UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    protected static String parentBracketChildString(String parent, String child) {
        return String.format("%s[%s]", parent, child);
    }

    protected static String wrapInXMLTag(String tagName, String xml) {
        return String.format("<%s>%s</%s>", tagName, xml, tagName);
    }

    protected static String wrapInXMLTag(String tagName, String xml, String type) {
        return String.format("<%s type=\"%s\">%s</%s>", tagName, type, xml, tagName);
    }

    protected static String xmlEscape(String input) {
        return input.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }
}

