/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.CreditCard;
import com.braintreegateway.CreditCardVerification;
import com.braintreegateway.Customer;
import com.braintreegateway.SettlementBatchSummary;
import com.braintreegateway.Subscription;
import com.braintreegateway.Transaction;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.util.NodeWrapper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result<T> {
    private CreditCardVerification creditCardVerification;
    private Transaction transaction;
    private Subscription subscription;
    private ValidationErrors errors;
    private Map<String, String> parameters;
    private String message;
    private T target;

    public static <T> T newInstanceFromNode(Class<T> klass, NodeWrapper node) {
        if (klass == CreditCard.class) {
            return (T)new CreditCard(node);
        }
        if (klass == Address.class) {
            return (T)new Address(node);
        }
        if (klass == Customer.class) {
            return (T)new Customer(node);
        }
        if (klass == Subscription.class) {
            return (T)new Subscription(node);
        }
        if (klass == Transaction.class) {
            return (T)new Transaction(node);
        }
        if (klass == SettlementBatchSummary.class) {
            return (T)new SettlementBatchSummary(node);
        }
        throw new IllegalArgumentException("Unknown klass: " + klass);
    }

    public Result() {
    }

    public Result(NodeWrapper node, Class<T> klass) {
        if (node.isSuccess()) {
            this.target = Result.newInstanceFromNode(klass, node);
        } else {
            NodeWrapper subscriptionNode;
            NodeWrapper transactionNode;
            this.errors = new ValidationErrors(node);
            NodeWrapper verificationNode = node.findFirst("verification");
            if (verificationNode != null) {
                this.creditCardVerification = new CreditCardVerification(verificationNode);
            }
            if ((transactionNode = node.findFirst("transaction")) != null) {
                this.transaction = new Transaction(transactionNode);
            }
            if ((subscriptionNode = node.findFirst("subscription")) != null) {
                this.subscription = new Subscription(subscriptionNode);
            }
            this.parameters = node.findFirst("params").getFormParameters();
            this.message = node.findString("message");
        }
    }

    public CreditCardVerification getCreditCardVerification() {
        return this.creditCardVerification;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public ValidationErrors getErrors() {
        return this.errors;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public T getTarget() {
        return this.target;
    }

    public boolean isSuccess() {
        return this.errors == null;
    }

    public String getMessage() {
        return this.message;
    }
}

