/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class AndroidPayCard
implements PaymentMethod {
    private String cardType;
    private String last4;
    private String sourceCardType;
    private String sourceCardLast4;
    private String sourceDescription;
    private String virtualCardType;
    private String virtualCardLast4;
    private String expirationMonth;
    private String expirationYear;
    private String token;
    private String googleTransactionId;
    private String bin;
    private Boolean isDefault;
    private String imageUrl;
    private String customerId;
    private Calendar createdAt;
    private Calendar updatedAt;
    private List<Subscription> subscriptions;

    public AndroidPayCard(NodeWrapper node) {
        this.sourceCardType = node.findString("source-card-type");
        this.sourceCardLast4 = node.findString("source-card-last-4");
        this.sourceDescription = node.findString("source-description");
        this.virtualCardType = node.findString("virtual-card-type");
        this.virtualCardLast4 = node.findString("virtual-card-last-4");
        this.cardType = this.virtualCardType;
        this.last4 = this.virtualCardLast4;
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.token = node.findString("token");
        this.googleTransactionId = node.findString("google-transaction-id");
        this.bin = node.findString("bin");
        this.isDefault = node.findBoolean("default");
        this.imageUrl = node.findString("image-url");
        this.customerId = node.findString("customer-id");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getSourceCardType() {
        return this.sourceCardType;
    }

    public String getSourceCardLast4() {
        return this.sourceCardLast4;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public String getVirtualCardType() {
        return this.virtualCardType;
    }

    public String getVirtualCardLast4() {
        return this.virtualCardLast4;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public String getGoogleTransactionId() {
        return this.googleTransactionId;
    }

    public String getBin() {
        return this.bin;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }
}

