/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.TransactionOptionsRequest;
import java.util.HashMap;
import java.util.Map;

public class TransactionOptionsPayPalRequest
extends Request {
    private TransactionOptionsRequest parent;
    private String customField;
    private String payeeId;
    private String payeeEmail;
    private String description;
    private Map<String, String> supplementaryData;

    public TransactionOptionsPayPalRequest(TransactionOptionsRequest parent) {
        this.parent = parent;
        this.supplementaryData = new HashMap<String, String>();
    }

    public TransactionOptionsRequest done() {
        return this.parent;
    }

    public TransactionOptionsPayPalRequest customField(String customField) {
        this.customField = customField;
        return this;
    }

    public TransactionOptionsPayPalRequest payeeId(String payeeId) {
        this.payeeId = payeeId;
        return this;
    }

    public TransactionOptionsPayPalRequest payeeEmail(String payeeEmail) {
        this.payeeEmail = payeeEmail;
        return this;
    }

    public TransactionOptionsPayPalRequest description(String description) {
        this.description = description;
        return this;
    }

    public TransactionOptionsPayPalRequest supplementaryData(String key, String value) {
        this.supplementaryData.put(key, value);
        return this;
    }

    @Override
    public String toXML() {
        return this.buildRequest("paypal").toXML();
    }

    @Override
    public String toQueryString() {
        return this.toQueryString("paypal");
    }

    @Override
    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root).addElement("description", this.description).addElement("customField", this.customField).addElement("payeeId", this.payeeId).addElement("payeeEmail", this.payeeEmail);
        if (!this.supplementaryData.isEmpty()) {
            builder.addElement("supplementaryData", this.supplementaryData);
        }
        return builder;
    }
}

