/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.http.serializer;

import com.braintreepayments.http.annotations.Model;
import com.braintreepayments.http.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectMapper {
    private static final Set<Class> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Void.class));
    private static final Set<Class> NUMERIC_TYPES = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class));

    public static Map<String, Object> map(Object o) throws IllegalAccessException {
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        Class<?> oClass = o.getClass();
        for (Field f : oClass.getDeclaredFields()) {
            if (Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            SerializedName sn = f.getAnnotation(SerializedName.class);
            if (sn == null) continue;
            String key = sn.value();
            Object value = f.get(o);
            if (value == null) continue;
            if (ObjectMapper.isPrimitive(value)) {
                serialized.put(key, value);
                continue;
            }
            if (value instanceof List) {
                ArrayList valueList = new ArrayList();
                for (Object subValue : (List)value) {
                    if (ObjectMapper.isPrimitive(subValue)) {
                        valueList.add(subValue);
                        continue;
                    }
                    valueList.add(ObjectMapper.map(subValue));
                }
                serialized.put(key, valueList);
                continue;
            }
            serialized.put(key, ObjectMapper.map(value));
        }
        return serialized;
    }

    public static <T> T unmap(Map<String, Object> inputData, Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        T instance = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (String key : inputData.keySet()) {
            Object value = inputData.get(key);
            Field f = ObjectMapper.fieldForSerializedName(key, cls);
            if (f == null || value == null) continue;
            SerializedName sn = f.getAnnotation(SerializedName.class);
            f.setAccessible(true);
            if (ObjectMapper.isPrimitive(value)) {
                if (ObjectMapper.isNumeric(f.getType())) {
                    f.set(instance, ObjectMapper.numericCast(f.getType(), (Number)value));
                    continue;
                }
                f.set(instance, value);
                continue;
            }
            if (value instanceof List) {
                List sourceList;
                Class listClass = sn.listClass();
                if (listClass.equals(Void.class)) {
                    throw new InstantiationException("Generated array properties must set the listClass property on SerializedName");
                }
                ArrayList<T> destList = new ArrayList<T>();
                if (ObjectMapper.isPrimitive(listClass)) {
                    sourceList = (List)value;
                    for (Object sourceListValue : sourceList) {
                        destList.add(listClass.cast(sourceListValue));
                    }
                } else {
                    sourceList = (List)value;
                    for (Map subValue : sourceList) {
                        destList.add(ObjectMapper.unmap(subValue, listClass));
                    }
                }
                f.set(instance, destList);
                continue;
            }
            f.set(instance, ObjectMapper.unmap((Map)value, f.getType()));
        }
        return instance;
    }

    private static Field fieldForSerializedName(String name, Class cls) {
        Field target = null;
        for (Field f : cls.getDeclaredFields()) {
            SerializedName sn = f.getAnnotation(SerializedName.class);
            if (sn == null || !name.equals(sn.value())) continue;
            target = f;
            break;
        }
        return target;
    }

    public static boolean isModel(Object o) {
        return o.getClass().getAnnotation(Model.class) != null;
    }

    private static boolean isPrimitive(Object o) {
        return o != null && ObjectMapper.isPrimitive(o.getClass());
    }

    private static boolean isPrimitive(Class cls) {
        return cls.isPrimitive() || ObjectMapper.isWrapperType(cls);
    }

    private static boolean isNumeric(Class cls) {
        return NUMERIC_TYPES.contains(cls);
    }

    private static Object numericCast(Class dest, Number o) {
        if (dest.equals(Byte.class)) {
            return o.byteValue();
        }
        if (dest.equals(Short.class)) {
            return o.shortValue();
        }
        if (dest.equals(Integer.class)) {
            return o.intValue();
        }
        if (dest.equals(Long.class)) {
            return o.longValue();
        }
        if (dest.equals(Float.class)) {
            return Float.valueOf(o.floatValue());
        }
        if (dest.equals(Double.class)) {
            return o.doubleValue();
        }
        return null;
    }

    private static boolean isWrapperType(Class cls) {
        return WRAPPER_TYPES.contains(cls);
    }
}

