/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.http;

import com.braintreepayments.http.Headers;
import com.braintreepayments.http.HttpRequest;
import com.braintreepayments.http.serializer.FormEncoded;
import com.braintreepayments.http.serializer.Json;
import com.braintreepayments.http.serializer.Multipart;
import com.braintreepayments.http.serializer.Serializer;
import com.braintreepayments.http.serializer.StreamUtils;
import com.braintreepayments.http.serializer.Text;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class Encoder {
    private List<Serializer> serializers = new ArrayList<Serializer>();

    public void registerSerializer(Serializer serializer) {
        this.serializers.add(serializer);
    }

    public Encoder() {
        this.registerSerializer(new Json());
        this.registerSerializer(new Text());
        this.registerSerializer(new Multipart());
        this.registerSerializer(new FormEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeRequest(HttpRequest request) throws IOException {
        String contentType = request.headers().header("Content-Type");
        if (contentType != null) {
            Serializer serializer = this.serializer(contentType);
            if (serializer == null) {
                throw new UnsupportedEncodingException(String.format("Unable to encode request with Content-Type: %s. Supported encodings are: %s", request.headers().header("Content-Type"), this.supportedEncodings()));
            }
            byte[] encoded = serializer.encode(request);
            if ("gzip".equals(request.headers().header("Content-Encoding"))) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                try {
                    gzos.write(encoded);
                }
                finally {
                    bos.close();
                    gzos.close();
                }
                return bos.toByteArray();
            }
            return encoded;
        }
        throw new UnsupportedEncodingException("HttpRequest does not have Content-Type header set");
    }

    public <T> T deserializeResponse(InputStream stream, Class<T> responseClass, Headers headers) throws IOException {
        String contentType = headers.header("Content-Type");
        String contentEncoding = headers.header("Content-Encoding");
        String responseBody = StreamUtils.readStream(stream, contentEncoding);
        stream.close();
        if (responseClass.isAssignableFrom(String.class)) {
            return (T)responseBody;
        }
        if (responseBody.isEmpty()) {
            return null;
        }
        if (contentType == null) {
            throw new UnsupportedEncodingException("HttpResponse does not have Content-Type header set");
        }
        Serializer serializer = this.serializer(contentType);
        if (serializer == null) {
            throw new UnsupportedEncodingException(String.format("Unable to decode response with Content-Type: %s. Supported decodings are: %s", headers.header("Content-Type"), this.supportedEncodings()));
        }
        if (responseBody.length() > 0) {
            return serializer.decode(responseBody, responseClass);
        }
        return null;
    }

    private List<String> supportedEncodings() {
        ArrayList<String> supportedEncodings = new ArrayList<String>();
        for (Serializer serializer : this.serializers) {
            supportedEncodings.add(serializer.contentType());
        }
        return supportedEncodings;
    }

    private Serializer serializer(String contentType) {
        if (contentType.contains(";")) {
            contentType = contentType.split(";")[0];
        }
        for (Serializer s : this.serializers) {
            if (!contentType.matches(s.contentType())) continue;
            return s;
        }
        return null;
    }
}

