/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.HttpRequest;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.TLSSocketFactory;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

class SynchronousHttpClient {
    private SSLSocketFactory socketFactory;
    private final HttpResponseParser parser;

    SynchronousHttpClient(SSLSocketFactory socketFactory, HttpResponseParser parser) {
        this.parser = parser;
        if (socketFactory != null) {
            this.socketFactory = socketFactory;
        } else {
            try {
                this.socketFactory = TLSSocketFactory.newInstance();
            }
            catch (SSLException e) {
                this.socketFactory = null;
            }
        }
    }

    void setSSLSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String request(HttpRequest httpRequest) throws Exception {
        if (httpRequest.getPath() == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        URL url = httpRequest.getURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            if (this.socketFactory == null) {
                throw new SSLException("SSLSocketFactory was not set or failed to initialize");
            }
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.socketFactory);
        }
        String requestMethod = httpRequest.getMethod();
        connection.setRequestMethod(requestMethod);
        connection.setReadTimeout(httpRequest.getReadTimeout());
        connection.setConnectTimeout(httpRequest.getConnectTimeout());
        Map<String, String> headers = httpRequest.getHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (requestMethod != null && requestMethod.equals("POST")) {
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(httpRequest.getData());
            outputStream.flush();
            outputStream.close();
            httpRequest.dispose();
        }
        try {
            int responseCode = connection.getResponseCode();
            String string = this.parser.parse(responseCode, connection);
            return string;
        }
        finally {
            connection.disconnect();
        }
    }
}

