/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.CertificateHelper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

class SignatureVerifier {
    private final CertificateHelper certificateHelper;

    SignatureVerifier() {
        this(new CertificateHelper());
    }

    @VisibleForTesting
    SignatureVerifier(CertificateHelper certificateHelper) {
        this.certificateHelper = certificateHelper;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    boolean isSignatureValid(Context context, String packageName, String base64EncodedSignature) {
        Signature[] signatures;
        PackageManager packageManager = context.getPackageManager();
        try {
            signatures = packageManager.getPackageInfo((String)packageName, (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        if (signatures.length == 0) {
            return false;
        }
        for (Signature signature : signatures) {
            String currentSignature;
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] encodedCert = this.certificateHelper.getEncodedCertificate(signature.toByteArray());
                currentSignature = Base64.encodeToString((byte[])md.digest(encodedCert), (int)0);
            }
            catch (NoSuchAlgorithmException | CertificateException e) {
                return false;
            }
            boolean validated = base64EncodedSignature.equals(currentSignature);
            if (validated) continue;
            return false;
        }
        return true;
    }
}

