/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.braintreepayments.api.AppHelper;

class ManifestValidator {
    ManifestValidator() {
    }

    <T> boolean isActivityDeclaredInAndroidManifest(Context context, Class<T> klass) {
        return this.getActivityInfo(context, klass) != null;
    }

    <T> boolean isUrlSchemeDeclaredInAndroidManifest(Context context, String urlScheme, Class<T> klass) {
        Intent intent = new Intent("android.intent.action.VIEW").setData(Uri.parse((String)(urlScheme + "://"))).addCategory("android.intent.category.DEFAULT").addCategory("android.intent.category.BROWSABLE");
        ActivityInfo activityInfo = this.getActivityInfo(context, klass);
        AppHelper appHelper = new AppHelper();
        return activityInfo != null && activityInfo.launchMode == 2 && appHelper.isIntentAvailable(context, intent);
    }

    @Nullable
    <T> ActivityInfo getActivityInfo(Context context, Class<T> klass) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 1);
            ActivityInfo[] activities = packageInfo.activities;
            if (activities != null) {
                for (ActivityInfo activityInfo : activities) {
                    if (!activityInfo.name.equals(klass.getName())) continue;
                    return activityInfo;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

