/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class HttpRequest {
    private static final int THIRTY_SECONDS_MS = 30000;
    private String path;
    private String baseUrl = "";
    private byte[] data;
    private String method;
    private final int readTimeout;
    private final int connectTimeout;
    private Map<String, String> headers = null;
    private final Map<String, String> additionalHeaders = new HashMap<String, String>();

    static HttpRequest newInstance() {
        return new HttpRequest();
    }

    HttpRequest() {
        this.readTimeout = 30000;
        this.connectTimeout = 30000;
    }

    HttpRequest path(String path) {
        this.path = path;
        return this;
    }

    HttpRequest baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    HttpRequest data(String dataAsString) {
        this.data = dataAsString.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    HttpRequest method(String method) {
        this.method = method;
        return this;
    }

    HttpRequest addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
        return this;
    }

    String getPath() {
        return this.path;
    }

    byte[] getData() {
        return this.data;
    }

    void dispose() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)0);
        }
    }

    String getMethod() {
        return this.method;
    }

    Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            this.headers.put("Accept-Encoding", "gzip");
            this.headers.put("Accept-Language", Locale.getDefault().getLanguage());
            this.headers.putAll(this.additionalHeaders);
        }
        return Collections.unmodifiableMap(this.headers);
    }

    int getReadTimeout() {
        return this.readTimeout;
    }

    int getConnectTimeout() {
        return this.connectTimeout;
    }

    URL getURL() throws MalformedURLException, URISyntaxException {
        URL url;
        if (this.path.startsWith("http")) {
            url = new URL(this.path);
        } else {
            URI baseURI = new URL(this.baseUrl).toURI();
            String newPath = HttpRequest.join(baseURI.getPath(), this.path);
            URI newURI = baseURI.resolve(newPath).normalize();
            url = newURI.toURL();
        }
        return url;
    }

    private static String join(String path1, String path2) {
        File f1 = new File(path1);
        File f2 = new File(f1, path2);
        return f2.getPath();
    }
}

