/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.CardNonce;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreeDSecureAuthenticationResponse
implements Parcelable {
    private static final String ERRORS_KEY = "errors";
    private static final String ERROR_KEY = "error";
    private static final String MESSAGE_KEY = "message";
    private static final String PAYMENT_METHOD_KEY = "paymentMethod";
    private static final String SUCCESS_KEY = "success";
    private CardNonce mCardNonce;
    private boolean mSuccess;
    private String mErrors;
    private String mException;
    public static final Parcelable.Creator<ThreeDSecureAuthenticationResponse> CREATOR = new Parcelable.Creator<ThreeDSecureAuthenticationResponse>(){

        public ThreeDSecureAuthenticationResponse createFromParcel(Parcel source) {
            return new ThreeDSecureAuthenticationResponse(source);
        }

        public ThreeDSecureAuthenticationResponse[] newArray(int size) {
            return new ThreeDSecureAuthenticationResponse[size];
        }
    };

    public static ThreeDSecureAuthenticationResponse fromJson(String jsonString) {
        ThreeDSecureAuthenticationResponse authenticationResponse = new ThreeDSecureAuthenticationResponse();
        try {
            JSONObject json = new JSONObject(jsonString);
            JSONObject cardJson = json.optJSONObject(PAYMENT_METHOD_KEY);
            if (cardJson != null) {
                CardNonce cardNonce = new CardNonce();
                cardNonce.fromJson(cardJson);
                authenticationResponse.mCardNonce = cardNonce;
            }
            if (json.has(SUCCESS_KEY)) {
                if (json.has(ERROR_KEY)) {
                    authenticationResponse.mErrors = Json.optString((JSONObject)json.getJSONObject(ERROR_KEY), (String)MESSAGE_KEY, null);
                }
                authenticationResponse.mSuccess = json.getBoolean(SUCCESS_KEY);
            } else {
                if (json.has(ERRORS_KEY)) {
                    authenticationResponse.mErrors = Json.optString((JSONObject)json.getJSONArray(ERRORS_KEY).getJSONObject(0), (String)MESSAGE_KEY, null);
                }
                authenticationResponse.mSuccess = authenticationResponse.mErrors == null;
            }
        }
        catch (JSONException e) {
            authenticationResponse.mSuccess = false;
        }
        return authenticationResponse;
    }

    @Deprecated
    public static CardNonce getNonceWithAuthenticationDetails(String jsonString, CardNonce lookupCardNonce) {
        ThreeDSecureAuthenticationResponse authenticationResponse = new ThreeDSecureAuthenticationResponse();
        CardNonce nonceToReturn = lookupCardNonce;
        try {
            JSONObject json = new JSONObject(jsonString);
            if (json.has(SUCCESS_KEY)) {
                authenticationResponse.mSuccess = json.getBoolean(SUCCESS_KEY);
            } else if (!json.has(ERRORS_KEY)) {
                authenticationResponse.mSuccess = true;
            }
            if (authenticationResponse.mSuccess) {
                JSONObject cardJson = json.optJSONObject(PAYMENT_METHOD_KEY);
                if (cardJson != null) {
                    nonceToReturn = new CardNonce();
                    nonceToReturn.fromJson(cardJson);
                }
            } else {
                authenticationResponse.mErrors = jsonString;
            }
        }
        catch (JSONException e) {
            authenticationResponse.mSuccess = false;
            authenticationResponse.mException = e.getMessage();
        }
        nonceToReturn.getThreeDSecureInfo().setThreeDSecureAuthenticationResponse(authenticationResponse);
        return nonceToReturn;
    }

    @Deprecated
    public static ThreeDSecureAuthenticationResponse fromException(String exception) {
        ThreeDSecureAuthenticationResponse authenticationResponse = new ThreeDSecureAuthenticationResponse();
        authenticationResponse.mSuccess = false;
        authenticationResponse.mException = exception;
        return authenticationResponse;
    }

    @Deprecated
    public boolean isSuccess() {
        return this.mSuccess;
    }

    public CardNonce getCardNonce() {
        return this.mCardNonce;
    }

    @Deprecated
    public String getErrors() {
        return this.mErrors;
    }

    public String getException() {
        return this.mException;
    }

    public ThreeDSecureAuthenticationResponse() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.mSuccess ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.mCardNonce, flags);
        dest.writeString(this.mErrors);
        dest.writeString(this.mException);
    }

    private ThreeDSecureAuthenticationResponse(Parcel in) {
        this.mSuccess = in.readByte() != 0;
        this.mCardNonce = (CardNonce)in.readParcelable(CardNonce.class.getClassLoader());
        this.mErrors = in.readString();
        this.mException = in.readString();
    }
}

