/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.PostalAddress;
import org.json.JSONObject;

public class PostalAddressParser {
    public static final String RECIPIENT_NAME_KEY = "recipientName";
    public static final String STREET_ADDRESS_KEY = "street1";
    public static final String EXTENDED_ADDRESS_KEY = "street2";
    public static final String LOCALITY_KEY = "city";
    public static final String COUNTRY_CODE_ALPHA_2_KEY = "country";
    public static final String POSTAL_CODE_KEY = "postalCode";
    public static final String REGION_KEY = "state";
    public static final String LINE_1_KEY = "line1";
    public static final String LINE_2_KEY = "line2";
    public static final String COUNTRY_CODE_KEY = "countryCode";
    public static final String USER_ADDRESS_NAME_KEY = "name";
    public static final String USER_ADDRESS_PHONE_NUMBER_KEY = "phoneNumber";
    public static final String USER_ADDRESS_ADDRESS_1_KEY = "address1";
    public static final String USER_ADDRESS_ADDRESS_2_KEY = "address2";
    public static final String USER_ADDRESS_ADDRESS_3_KEY = "address3";
    public static final String USER_ADDRESS_ADDRESS_4_KEY = "address4";
    public static final String USER_ADDRESS_ADDRESS_5_KEY = "address5";
    public static final String USER_ADDRESS_POSTAL_CODE_KEY = "postalCode";
    public static final String USER_ADDRESS_SORTING_CODE_KEY = "sortingCode";
    public static final String USER_ADDRESS_COUNTRY_CODE_KEY = "countryCode";
    public static final String USER_ADDRESS_LOCALITY_KEY = "locality";
    public static final String USER_ADDRESS_ADMINISTRATIVE_AREA_KEY = "administrativeArea";
    public static final String COUNTRY_CODE_UNDERSCORE_KEY = "country_code";
    public static final String POSTAL_CODE_UNDERSCORE_KEY = "postal_code";
    public static final String RECIPIENT_NAME_UNDERSCORE_KEY = "recipient_name";

    public static PostalAddress fromJson(JSONObject accountAddress) {
        if (accountAddress == null) {
            return new PostalAddress();
        }
        String streetAddress = Json.optString((JSONObject)accountAddress, (String)STREET_ADDRESS_KEY, null);
        String extendedAddress = Json.optString((JSONObject)accountAddress, (String)EXTENDED_ADDRESS_KEY, null);
        String countryCodeAlpha2 = Json.optString((JSONObject)accountAddress, (String)COUNTRY_CODE_ALPHA_2_KEY, null);
        if (streetAddress == null) {
            streetAddress = Json.optString((JSONObject)accountAddress, (String)LINE_1_KEY, null);
        }
        if (extendedAddress == null) {
            extendedAddress = Json.optString((JSONObject)accountAddress, (String)LINE_2_KEY, null);
        }
        if (countryCodeAlpha2 == null) {
            countryCodeAlpha2 = Json.optString((JSONObject)accountAddress, (String)"countryCode", null);
        }
        if (streetAddress == null && Json.optString((JSONObject)accountAddress, (String)USER_ADDRESS_NAME_KEY, null) != null) {
            return PostalAddressParser.fromUserAddressJson(accountAddress);
        }
        return new PostalAddress().recipientName(Json.optString((JSONObject)accountAddress, (String)RECIPIENT_NAME_KEY, null)).streetAddress(streetAddress).extendedAddress(extendedAddress).locality(Json.optString((JSONObject)accountAddress, (String)LOCALITY_KEY, null)).region(Json.optString((JSONObject)accountAddress, (String)REGION_KEY, null)).postalCode(Json.optString((JSONObject)accountAddress, (String)"postalCode", null)).countryCodeAlpha2(countryCodeAlpha2);
    }

    public static PostalAddress fromUserAddressJson(JSONObject json) {
        PostalAddress address = new PostalAddress();
        address.recipientName(Json.optString((JSONObject)json, (String)USER_ADDRESS_NAME_KEY, (String)"")).phoneNumber(Json.optString((JSONObject)json, (String)USER_ADDRESS_PHONE_NUMBER_KEY, (String)"")).streetAddress(Json.optString((JSONObject)json, (String)USER_ADDRESS_ADDRESS_1_KEY, (String)"")).extendedAddress(PostalAddressParser.formatExtendedUserAddress(json)).locality(Json.optString((JSONObject)json, (String)USER_ADDRESS_LOCALITY_KEY, (String)"")).region(Json.optString((JSONObject)json, (String)USER_ADDRESS_ADMINISTRATIVE_AREA_KEY, (String)"")).countryCodeAlpha2(Json.optString((JSONObject)json, (String)"countryCode", (String)"")).postalCode(Json.optString((JSONObject)json, (String)"postalCode", (String)"")).sortingCode(Json.optString((JSONObject)json, (String)USER_ADDRESS_SORTING_CODE_KEY, (String)""));
        return address;
    }

    private static String formatExtendedUserAddress(JSONObject address) {
        String extendedAddress = "" + Json.optString((JSONObject)address, (String)USER_ADDRESS_ADDRESS_2_KEY, (String)"") + "\n" + Json.optString((JSONObject)address, (String)USER_ADDRESS_ADDRESS_3_KEY, (String)"") + "\n" + Json.optString((JSONObject)address, (String)USER_ADDRESS_ADDRESS_4_KEY, (String)"") + "\n" + Json.optString((JSONObject)address, (String)USER_ADDRESS_ADDRESS_5_KEY, (String)"");
        return extendedAddress.trim();
    }
}

