/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import com.braintreepayments.api.Json;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalTwoFactorAuthResponse {
    private static final String PAYMENT_TOKEN_KEY = "paymentToken";
    private static final String INTENT_KEY = "intent";
    private static final String REDIRECT_URL_KEY = "redirectUrl";
    private static final String AUTHENTICATE_URL_KEY = "authenticateUrl";
    private String mPaymentToken;
    private String mIntent;
    private String mRedirectUrl;
    private String mAuthenticateUrl;
    private String mAuthorizationFingerprint;

    public static PayPalTwoFactorAuthResponse fromJson(String string, String authorizationFingerprint) throws JSONException {
        PayPalTwoFactorAuthResponse response = new PayPalTwoFactorAuthResponse();
        JSONObject json = new JSONObject(string).getJSONObject("paymentResource");
        response.mPaymentToken = Json.optString((JSONObject)json, (String)PAYMENT_TOKEN_KEY, null);
        response.mIntent = Json.optString((JSONObject)json, (String)INTENT_KEY, null);
        response.mRedirectUrl = Json.optString((JSONObject)json, (String)REDIRECT_URL_KEY, null);
        response.mAuthenticateUrl = Json.optString((JSONObject)json, (String)AUTHENTICATE_URL_KEY, null);
        response.mAuthorizationFingerprint = authorizationFingerprint;
        return response;
    }

    public String getAuthenticateUrl() {
        return this.mAuthenticateUrl;
    }

    public String getPaymentToken() {
        return this.mPaymentToken;
    }

    public String getResourceIntent() {
        return this.mIntent;
    }

    public String getRedirectUrl() {
        return this.mRedirectUrl;
    }

    public String toJson(String correlationId) {
        JSONObject parameters = new JSONObject();
        try {
            boolean scaAuthenticationComplete = this.mAuthenticateUrl == null;
            parameters.put("paypal_account", (Object)new JSONObject().put("correlation_id", (Object)correlationId).put("payment_token", (Object)this.mPaymentToken).put("options", (Object)new JSONObject().put("sca_authentication_complete", scaAuthenticationComplete))).put("authorization_fingerprint", (Object)this.mAuthorizationFingerprint);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return parameters.toString();
    }
}

