/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.content.Context;
import com.braintreepayments.api.models.PaymentMethodBuilder;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalAccountBuilder
extends PaymentMethodBuilder<PayPalAccountBuilder> {
    private static final String PAYPAL_ACCOUNT_KEY = "paypalAccount";
    private static final String CORRELATION_ID_KEY = "correlationId";
    private static final String INTENT_KEY = "intent";
    private static final String MERCHANT_ACCOUNT_ID_KEY = "merchant_account_id";
    private String mClientMetadataId;
    private JSONObject mOneTouchCoreData = new JSONObject();
    private String mIntent;
    private String mMerchantAccountId;

    public PayPalAccountBuilder clientMetadataId(String clientMetadataId) {
        this.mClientMetadataId = clientMetadataId;
        return this;
    }

    public PayPalAccountBuilder oneTouchCoreData(JSONObject otcData) {
        if (otcData != null) {
            this.mOneTouchCoreData = otcData;
        }
        return this;
    }

    public PayPalAccountBuilder intent(String intent) {
        this.mIntent = intent;
        return this;
    }

    public PayPalAccountBuilder merchantAccountId(String merchantAccountId) {
        this.mMerchantAccountId = merchantAccountId;
        return this;
    }

    @Override
    protected void build(JSONObject base, JSONObject paymentMethodNonceJson) throws JSONException {
        paymentMethodNonceJson.put(CORRELATION_ID_KEY, (Object)this.mClientMetadataId);
        paymentMethodNonceJson.put(INTENT_KEY, (Object)this.mIntent);
        Iterator otcKeyIterator = this.mOneTouchCoreData.keys();
        while (otcKeyIterator.hasNext()) {
            String otcKey = (String)otcKeyIterator.next();
            paymentMethodNonceJson.put(otcKey, this.mOneTouchCoreData.get(otcKey));
        }
        if (this.mMerchantAccountId != null) {
            base.put(MERCHANT_ACCOUNT_ID_KEY, (Object)this.mMerchantAccountId);
        }
        base.put(PAYPAL_ACCOUNT_KEY, (Object)paymentMethodNonceJson);
    }

    @Override
    protected void buildGraphQL(Context context, JSONObject base, JSONObject input) {
    }

    @Override
    public String getApiPath() {
        return "paypal_accounts";
    }

    @Override
    public String getResponsePaymentMethodType() {
        return "PayPalAccount";
    }
}

