/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.text.TextUtils;
import com.braintreepayments.api.Json;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class GraphQLConfiguration {
    private String mUrl;
    private Set<String> mFeatures;

    public static GraphQLConfiguration fromJson(JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        GraphQLConfiguration graphQLConfiguration = new GraphQLConfiguration();
        graphQLConfiguration.mUrl = Json.optString((JSONObject)json, (String)"url", (String)"");
        graphQLConfiguration.mFeatures = GraphQLConfiguration.parseJsonFeatures(json.optJSONArray("features"));
        return graphQLConfiguration;
    }

    public boolean isEnabled() {
        return !TextUtils.isEmpty((CharSequence)this.mUrl);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean isFeatureEnabled(String feature) {
        return this.isEnabled() && this.mFeatures.contains(feature);
    }

    private static Set<String> parseJsonFeatures(JSONArray jsonArray) {
        HashSet<String> features = new HashSet<String>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                features.add(jsonArray.optString(i, ""));
            }
        }
        return features;
    }
}

