/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class CardConfiguration {
    private static final String SUPPORTED_CARD_TYPES_KEY = "supportedCardTypes";
    private static final String COLLECT_DEVICE_DATA_KEY = "collectDeviceData";
    private final Set<String> mSupportedCardTypes = new HashSet<String>();
    private boolean mCollectFraudData = false;

    public static CardConfiguration fromJson(JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        CardConfiguration cardConfiguration = new CardConfiguration();
        JSONArray jsonArray = json.optJSONArray(SUPPORTED_CARD_TYPES_KEY);
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                cardConfiguration.mSupportedCardTypes.add(jsonArray.optString(i, ""));
            }
        }
        cardConfiguration.mCollectFraudData = json.optBoolean(COLLECT_DEVICE_DATA_KEY, false);
        return cardConfiguration;
    }

    public Set<String> getSupportedCardTypes() {
        return Collections.unmodifiableSet(this.mSupportedCardTypes);
    }

    public boolean isFraudDataCollectionEnabled() {
        return this.mCollectFraudData;
    }
}

