/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.models.BaseCardBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class CardBuilder
extends BaseCardBuilder<CardBuilder>
implements Parcelable {
    private static final String MERCHANT_ACCOUNT_ID_KEY = "merchantAccountId";
    private static final String AUTHENTICATION_INSIGHT_REQUESTED_KEY = "authenticationInsight";
    private static final String AUTHENTICATION_INSIGHT_INPUT_KEY = "authenticationInsightInput";
    private String mMerchantAccountId;
    private boolean mAuthenticationInsightRequested;
    public static final Parcelable.Creator<CardBuilder> CREATOR = new Parcelable.Creator<CardBuilder>(){

        public CardBuilder createFromParcel(Parcel in) {
            return new CardBuilder(in);
        }

        public CardBuilder[] newArray(int size) {
            return new CardBuilder[size];
        }
    };

    @Override
    protected void buildGraphQL(Context context, JSONObject base, JSONObject variables) throws BraintreeException, JSONException {
        JSONObject input = variables.getJSONObject("input");
        if (TextUtils.isEmpty((CharSequence)this.mMerchantAccountId) && this.mAuthenticationInsightRequested) {
            throw new BraintreeException("A merchant account ID is required when authenticationInsightRequested is true.");
        }
        if (this.mAuthenticationInsightRequested) {
            variables.put(AUTHENTICATION_INSIGHT_INPUT_KEY, (Object)new JSONObject().put(MERCHANT_ACCOUNT_ID_KEY, (Object)this.mMerchantAccountId));
        }
        base.put("query", (Object)this.getCardTokenizationGraphQLMutation());
        base.put("operationName", (Object)"TokenizeCreditCard");
        JSONObject creditCard = new JSONObject().put("number", (Object)this.mCardnumber).put("expirationMonth", (Object)this.mExpirationMonth).put("expirationYear", (Object)this.mExpirationYear).put("cvv", (Object)this.mCvv).put("cardholderName", (Object)this.mCardholderName);
        JSONObject billingAddress = new JSONObject().put("firstName", (Object)this.mFirstName).put("lastName", (Object)this.mLastName).put("company", (Object)this.mCompany).put("countryCode", (Object)this.mCountryCode).put("locality", (Object)this.mLocality).put("postalCode", (Object)this.mPostalCode).put("region", (Object)this.mRegion).put("streetAddress", (Object)this.mStreetAddress).put("extendedAddress", (Object)this.mExtendedAddress);
        if (billingAddress.length() > 0) {
            creditCard.put("billingAddress", (Object)billingAddress);
        }
        input.put("creditCard", (Object)creditCard);
    }

    public CardBuilder() {
    }

    public CardBuilder merchantAccountId(String id) {
        this.mMerchantAccountId = TextUtils.isEmpty((CharSequence)id) ? null : id;
        return this;
    }

    public CardBuilder authenticationInsightRequested(boolean requested) {
        this.mAuthenticationInsightRequested = requested;
        return this;
    }

    @Override
    protected void build(JSONObject json, JSONObject paymentMethodNonceJson) throws JSONException {
        super.build(json, paymentMethodNonceJson);
        if (this.mAuthenticationInsightRequested) {
            json.put(MERCHANT_ACCOUNT_ID_KEY, (Object)this.mMerchantAccountId);
            json.put(AUTHENTICATION_INSIGHT_REQUESTED_KEY, this.mAuthenticationInsightRequested);
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mMerchantAccountId);
        dest.writeByte(this.mAuthenticationInsightRequested ? (byte)1 : 0);
    }

    protected CardBuilder(Parcel in) {
        super(in);
        this.mMerchantAccountId = in.readString();
        this.mAuthenticationInsightRequested = in.readByte() > 0;
    }

    private String getCardTokenizationGraphQLMutation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mutation TokenizeCreditCard($input: TokenizeCreditCardInput!");
        if (this.mAuthenticationInsightRequested) {
            stringBuilder.append(", $authenticationInsightInput: AuthenticationInsightInput!");
        }
        stringBuilder.append(") {  tokenizeCreditCard(input: $input) {    token    creditCard {      bin      brand      expirationMonth      expirationYear      cardholderName      last4      binData {        prepaid        healthcare        debit        durbinRegulated        commercial        payroll        issuingBank        countryOfIssuance        productId      }    }");
        if (this.mAuthenticationInsightRequested) {
            stringBuilder.append("    authenticationInsight(input: $authenticationInsightInput) {      customerAuthenticationRegulationEnvironment    }");
        }
        stringBuilder.append("  }}");
        return stringBuilder.toString();
    }
}

