/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.braintreepayments.api.models.PaymentMethodBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseCardBuilder<T>
extends PaymentMethodBuilder<T>
implements Parcelable {
    static final String BILLING_ADDRESS_KEY = "billingAddress";
    static final String CARDHOLDER_NAME_KEY = "cardholderName";
    static final String COMPANY_KEY = "company";
    static final String COUNTRY_CODE_ALPHA3_KEY = "countryCodeAlpha3";
    static final String COUNTRY_CODE_KEY = "countryCode";
    static final String CREDIT_CARD_KEY = "creditCard";
    static final String CVV_KEY = "cvv";
    static final String EXPIRATION_MONTH_KEY = "expirationMonth";
    static final String EXPIRATION_YEAR_KEY = "expirationYear";
    static final String EXTENDED_ADDRESS_KEY = "extendedAddress";
    static final String FIRST_NAME_KEY = "firstName";
    static final String LAST_NAME_KEY = "lastName";
    static final String LOCALITY_KEY = "locality";
    static final String NUMBER_KEY = "number";
    static final String POSTAL_CODE_KEY = "postalCode";
    static final String REGION_KEY = "region";
    static final String STREET_ADDRESS_KEY = "streetAddress";
    String mCardholderName;
    String mCardnumber;
    String mCompany;
    String mCountryCode;
    String mCvv;
    String mExpirationMonth;
    String mExpirationYear;
    String mExtendedAddress;
    String mFirstName;
    String mLastName;
    String mLocality;
    String mPostalCode;
    String mRegion;
    String mStreetAddress;

    public BaseCardBuilder() {
    }

    public T cardNumber(String number) {
        this.mCardnumber = TextUtils.isEmpty((CharSequence)number) ? null : number;
        return (T)this;
    }

    public T cvv(String cvv) {
        this.mCvv = TextUtils.isEmpty((CharSequence)cvv) ? null : cvv;
        return (T)this;
    }

    public T expirationMonth(String expirationMonth) {
        this.mExpirationMonth = TextUtils.isEmpty((CharSequence)expirationMonth) ? null : expirationMonth;
        return (T)this;
    }

    public T expirationYear(String expirationYear) {
        this.mExpirationYear = TextUtils.isEmpty((CharSequence)expirationYear) ? null : expirationYear;
        return (T)this;
    }

    public T expirationDate(String expirationDate) {
        if (TextUtils.isEmpty((CharSequence)expirationDate)) {
            this.mExpirationMonth = null;
            this.mExpirationYear = null;
        } else {
            String[] splitExpiration = expirationDate.split("/");
            this.mExpirationMonth = splitExpiration[0];
            if (splitExpiration.length > 1) {
                this.mExpirationYear = splitExpiration[1];
            }
        }
        return (T)this;
    }

    public T cardholderName(String cardholderName) {
        this.mCardholderName = TextUtils.isEmpty((CharSequence)cardholderName) ? null : cardholderName;
        return (T)this;
    }

    public T firstName(String firstName) {
        this.mFirstName = TextUtils.isEmpty((CharSequence)firstName) ? null : firstName;
        return (T)this;
    }

    public T lastName(String lastName) {
        this.mLastName = TextUtils.isEmpty((CharSequence)lastName) ? null : lastName;
        return (T)this;
    }

    public T company(String company) {
        this.mCompany = TextUtils.isEmpty((CharSequence)company) ? null : company;
        return (T)this;
    }

    public T countryCode(String countryCode) {
        this.mCountryCode = TextUtils.isEmpty((CharSequence)countryCode) ? null : countryCode;
        return (T)this;
    }

    public T locality(String locality) {
        this.mLocality = TextUtils.isEmpty((CharSequence)locality) ? null : locality;
        return (T)this;
    }

    public T postalCode(String postalCode) {
        this.mPostalCode = TextUtils.isEmpty((CharSequence)postalCode) ? null : postalCode;
        return (T)this;
    }

    public T region(String region) {
        this.mRegion = TextUtils.isEmpty((CharSequence)region) ? null : region;
        return (T)this;
    }

    public T streetAddress(String streetAddress) {
        this.mStreetAddress = TextUtils.isEmpty((CharSequence)streetAddress) ? null : streetAddress;
        return (T)this;
    }

    public T extendedAddress(String extendedAddress) {
        this.mExtendedAddress = TextUtils.isEmpty((CharSequence)extendedAddress) ? null : extendedAddress;
        return (T)this;
    }

    @Override
    protected void build(JSONObject json, JSONObject paymentMethodNonceJson) throws JSONException {
        paymentMethodNonceJson.put(NUMBER_KEY, (Object)this.mCardnumber);
        paymentMethodNonceJson.put(CVV_KEY, (Object)this.mCvv);
        paymentMethodNonceJson.put(EXPIRATION_MONTH_KEY, (Object)this.mExpirationMonth);
        paymentMethodNonceJson.put(EXPIRATION_YEAR_KEY, (Object)this.mExpirationYear);
        paymentMethodNonceJson.put(CARDHOLDER_NAME_KEY, (Object)this.mCardholderName);
        JSONObject billingAddressJson = new JSONObject();
        billingAddressJson.put(FIRST_NAME_KEY, (Object)this.mFirstName);
        billingAddressJson.put(LAST_NAME_KEY, (Object)this.mLastName);
        billingAddressJson.put(COMPANY_KEY, (Object)this.mCompany);
        billingAddressJson.put(LOCALITY_KEY, (Object)this.mLocality);
        billingAddressJson.put(POSTAL_CODE_KEY, (Object)this.mPostalCode);
        billingAddressJson.put(REGION_KEY, (Object)this.mRegion);
        billingAddressJson.put(STREET_ADDRESS_KEY, (Object)this.mStreetAddress);
        billingAddressJson.put(EXTENDED_ADDRESS_KEY, (Object)this.mExtendedAddress);
        if (this.mCountryCode != null) {
            billingAddressJson.put(COUNTRY_CODE_ALPHA3_KEY, (Object)this.mCountryCode);
        }
        if (billingAddressJson.length() > 0) {
            paymentMethodNonceJson.put(BILLING_ADDRESS_KEY, (Object)billingAddressJson);
        }
        json.put(CREDIT_CARD_KEY, (Object)paymentMethodNonceJson);
    }

    @Override
    public String getApiPath() {
        return "credit_cards";
    }

    @Override
    public String getResponsePaymentMethodType() {
        return "CreditCard";
    }

    public int describeContents() {
        return 0;
    }

    protected BaseCardBuilder(Parcel in) {
        super(in);
        this.mCardnumber = in.readString();
        this.mCvv = in.readString();
        this.mExpirationMonth = in.readString();
        this.mExpirationYear = in.readString();
        this.mCardholderName = in.readString();
        this.mFirstName = in.readString();
        this.mLastName = in.readString();
        this.mCompany = in.readString();
        this.mCountryCode = in.readString();
        this.mLocality = in.readString();
        this.mPostalCode = in.readString();
        this.mRegion = in.readString();
        this.mStreetAddress = in.readString();
        this.mExtendedAddress = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCardnumber);
        dest.writeString(this.mCvv);
        dest.writeString(this.mExpirationMonth);
        dest.writeString(this.mExpirationYear);
        dest.writeString(this.mCardholderName);
        dest.writeString(this.mFirstName);
        dest.writeString(this.mLastName);
        dest.writeString(this.mCompany);
        dest.writeString(this.mCountryCode);
        dest.writeString(this.mLocality);
        dest.writeString(this.mPostalCode);
        dest.writeString(this.mRegion);
        dest.writeString(this.mStreetAddress);
        dest.writeString(this.mExtendedAddress);
    }
}

