/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.PayPalUAT;
import com.braintreepayments.api.models.TokenizationKey;

public abstract class Authorization
implements Parcelable {
    private final String mRawValue;

    public Authorization(String rawValue) {
        this.mRawValue = rawValue;
    }

    public static Authorization fromString(@Nullable String authorizationString) throws InvalidArgumentException {
        if (Authorization.isTokenizationKey(authorizationString)) {
            return new TokenizationKey(authorizationString);
        }
        if (Authorization.isPayPalUAT(authorizationString)) {
            return new PayPalUAT(authorizationString);
        }
        if (Authorization.isClientToken(authorizationString)) {
            return new ClientToken(authorizationString);
        }
        throw new InvalidArgumentException("Authorization provided is invalid: " + authorizationString);
    }

    public abstract String getConfigUrl();

    public abstract String getBearer();

    public String toString() {
        return this.mRawValue;
    }

    @Deprecated
    public static boolean isTokenizationKey(String tokenizationKey) {
        return !TextUtils.isEmpty((CharSequence)tokenizationKey) && tokenizationKey.matches("^[a-zA-Z0-9]+_[a-zA-Z0-9]+_[a-zA-Z0-9_]+$");
    }

    private static boolean isPayPalUAT(String payPalUAT) {
        return !TextUtils.isEmpty((CharSequence)payPalUAT) && payPalUAT.matches("^[a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9_-]+$");
    }

    private static boolean isClientToken(String clientToken) {
        return !TextUtils.isEmpty((CharSequence)clientToken) && clientToken.matches("([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)");
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.mRawValue);
    }

    public Authorization(Parcel in) {
        this.mRawValue = in.readString();
    }
}

