/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.internal;

import com.braintreepayments.api.Json;
import com.braintreepayments.api.exceptions.AuthorizationException;
import com.braintreepayments.api.exceptions.ErrorWithResponse;
import com.braintreepayments.api.exceptions.UnexpectedException;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.internal.BraintreeApiHttpClient;
import com.braintreepayments.api.internal.BraintreeGraphQLCertificate;
import com.braintreepayments.api.internal.TLSSocketFactory;
import java.net.HttpURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class BraintreeGraphQLHttpClient
extends BraintreeApiHttpClient {
    public BraintreeGraphQLHttpClient(String baseUrl, String bearer) {
        this(baseUrl, bearer, "2018-03-06");
    }

    private BraintreeGraphQLHttpClient(String baseUrl, String bearer, String apiVersion) {
        super(baseUrl, bearer, apiVersion);
        try {
            this.setSSLSocketFactory((SSLSocketFactory)new TLSSocketFactory(BraintreeGraphQLCertificate.getCertInputStream()));
        }
        catch (SSLException e) {
            this.setSSLSocketFactory(null);
        }
    }

    public void post(String data, HttpResponseCallback callback) {
        super.post("", data, callback);
    }

    @Override
    protected String parseResponse(HttpURLConnection connection) throws Exception {
        String response = super.parseResponse(connection);
        JSONArray errors = new JSONObject(response).optJSONArray("errors");
        if (errors != null) {
            for (int i = 0; i < errors.length(); ++i) {
                JSONObject error = errors.getJSONObject(i);
                JSONObject extensions = error.optJSONObject("extensions");
                String message = Json.optString((JSONObject)error, (String)"message", (String)"An Unexpected Exception Occurred");
                if (extensions == null) {
                    throw new UnexpectedException(message);
                }
                if (Json.optString((JSONObject)extensions, (String)"legacyCode", (String)"").equals("50000")) {
                    throw new AuthorizationException(error.getString("message"));
                }
                if (Json.optString((JSONObject)extensions, (String)"errorType", (String)"").equals("user_error")) continue;
                throw new UnexpectedException(message);
            }
            throw ErrorWithResponse.fromGraphQLJson(response);
        }
        return response;
    }
}

