/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.internal.AnalyticsDatabase;
import com.braintreepayments.api.internal.AnalyticsEvent;
import com.braintreepayments.api.internal.BraintreeHttpClient;
import com.braintreepayments.api.internal.UUIDHelper;
import com.braintreepayments.api.models.Authorization;
import com.braintreepayments.api.models.ClientToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsSender {
    private static final String ANALYTICS_KEY = "analytics";
    private static final String KIND_KEY = "kind";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String META_KEY = "_meta";
    private static final String TOKENIZATION_KEY = "tokenization_key";
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorization_fingerprint";
    private static final String PLATFORM_KEY = "platform";
    private static final String PLATFORM_VERSION_KEY = "platformVersion";
    private static final String SDK_VERSION_KEY = "sdkVersion";
    private static final String MERCHANT_APP_ID_KEY = "merchantAppId";
    private static final String MERCHANT_APP_NAME_KEY = "merchantAppName";
    private static final String DEVICE_ROOTED_KEY = "deviceRooted";
    private static final String DEVICE_MANUFACTURER_KEY = "deviceManufacturer";
    private static final String DEVICE_MODEL_KEY = "deviceModel";
    private static final String DEVICE_APP_GENERATED_PERSISTENT_UUID_KEY = "deviceAppGeneratedPersistentUuid";
    private static final String IS_SIMULATOR_KEY = "isSimulator";

    public static void send(Context context, Authorization authorization, BraintreeHttpClient httpClient, String analyticsUrl, boolean synchronous) {
        final AnalyticsDatabase db = AnalyticsDatabase.getInstance(context);
        List<List<AnalyticsEvent>> events = db.getPendingRequests();
        try {
            for (final List<AnalyticsEvent> innerEvents : events) {
                JSONObject analyticsRequest = AnalyticsSender.serializeEvents(context, authorization, innerEvents);
                try {
                    if (synchronous) {
                        httpClient.post(analyticsUrl, analyticsRequest.toString());
                        db.removeEvents(innerEvents);
                        continue;
                    }
                    httpClient.post(analyticsUrl, analyticsRequest.toString(), new HttpResponseCallback(){

                        public void success(String responseBody) {
                            db.removeEvents(innerEvents);
                        }

                        public void failure(Exception exception) {
                        }
                    });
                }
                catch (Exception exception) {}
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static JSONObject serializeEvents(Context context, Authorization authorization, List<AnalyticsEvent> events) throws JSONException {
        AnalyticsEvent primeEvent = events.get(0);
        JSONObject requestObject = new JSONObject();
        if (authorization instanceof ClientToken) {
            requestObject.put(AUTHORIZATION_FINGERPRINT_KEY, (Object)authorization.getBearer());
        } else {
            requestObject.put(TOKENIZATION_KEY, (Object)authorization.getBearer());
        }
        JSONObject meta = primeEvent.metadata.put(PLATFORM_KEY, (Object)"Android").put(PLATFORM_VERSION_KEY, (Object)Integer.toString(Build.VERSION.SDK_INT)).put(SDK_VERSION_KEY, (Object)"3.14.0").put(MERCHANT_APP_ID_KEY, (Object)context.getPackageName()).put(MERCHANT_APP_NAME_KEY, (Object)AnalyticsSender.getAppName(context)).put(DEVICE_ROOTED_KEY, (Object)AnalyticsSender.isDeviceRooted()).put(DEVICE_MANUFACTURER_KEY, (Object)Build.MANUFACTURER).put(DEVICE_MODEL_KEY, (Object)Build.MODEL).put(DEVICE_APP_GENERATED_PERSISTENT_UUID_KEY, (Object)UUIDHelper.getPersistentUUID(context)).put(IS_SIMULATOR_KEY, (Object)AnalyticsSender.detectEmulator());
        requestObject.put(META_KEY, (Object)meta);
        JSONArray eventObjects = new JSONArray();
        for (AnalyticsEvent analyticsEvent : events) {
            JSONObject eventObject = new JSONObject().put(KIND_KEY, (Object)analyticsEvent.event).put(TIMESTAMP_KEY, analyticsEvent.timestamp);
            eventObjects.put((Object)eventObject);
        }
        requestObject.put(ANALYTICS_KEY, (Object)eventObjects);
        return requestObject;
    }

    private static String detectEmulator() {
        if ("google_sdk".equalsIgnoreCase(Build.PRODUCT) || "sdk".equalsIgnoreCase(Build.PRODUCT) || "Genymotion".equalsIgnoreCase(Build.MANUFACTURER) || Build.FINGERPRINT.contains("generic")) {
            return "true";
        }
        return "false";
    }

    private static String getAppName(Context context) {
        ApplicationInfo applicationInfo;
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        try {
            applicationInfo = packageManager.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        String appName = null;
        if (applicationInfo != null) {
            appName = (String)packageManager.getApplicationLabel(applicationInfo);
        }
        if (appName == null) {
            return "ApplicationNameUnknown";
        }
        return appName;
    }

    private static String isDeviceRooted() {
        boolean check3;
        boolean check2;
        String buildTags = Build.TAGS;
        boolean check1 = buildTags != null && buildTags.contains("test-keys");
        try {
            check2 = new File("/system/app/Superuser.apk").exists();
        }
        catch (Exception e) {
            check2 = false;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/system/xbin/which", "su"});
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            check3 = in.readLine() != null;
        }
        catch (Exception e) {
            check3 = false;
        }
        return Boolean.toString(check1 || check2 || check3);
    }
}

