/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.AsyncTask;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.internal.AnalyticsEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsDatabase
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "braintree-analytics.db";
    private static final int DATABASE_VERSION = 1;
    private static final String TABLE_NAME = "analytics";
    static final String ID = "_id";
    static final String EVENT = "event";
    static final String TIMESTAMP = "timestamp";
    static final String META_JSON = "meta_json";
    protected final Set<AsyncTask> mTaskSet = new HashSet<AsyncTask>();

    public static AnalyticsDatabase getInstance(Context context) {
        return new AnalyticsDatabase(context, DATABASE_NAME, null, 1);
    }

    public AnalyticsDatabase(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, DATABASE_NAME, factory, 1);
    }

    public AnalyticsDatabase(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
        super(context, DATABASE_NAME, factory, 1, errorHandler);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table analytics(_id integer primary key autoincrement, event text not null, timestamp long not null, meta_json text not null);");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("drop table if exists analytics");
        this.onCreate(db);
    }

    public void addEvent(AnalyticsEvent request) {
        final ContentValues values = new ContentValues();
        values.put(EVENT, request.event);
        values.put(TIMESTAMP, Long.valueOf(request.timestamp));
        values.put(META_JSON, request.metadata.toString());
        DatabaseTask task = new DatabaseTask(new Runnable(){

            @Override
            public void run() {
                try (SQLiteDatabase db = null;){
                    db = AnalyticsDatabase.this.getWritableDatabase();
                    db.insert(AnalyticsDatabase.TABLE_NAME, null, values);
                }
            }
        });
        this.queueTask(task);
    }

    public void removeEvents(List<AnalyticsEvent> events) {
        final StringBuilder where = new StringBuilder(ID).append(" in (");
        final String[] whereArgs = new String[events.size()];
        for (int i = 0; i < events.size(); ++i) {
            whereArgs[i] = Integer.toString(events.get((int)i).id);
            where.append("?");
            if (i < events.size() - 1) {
                where.append(",");
                continue;
            }
            where.append(")");
        }
        DatabaseTask task = new DatabaseTask(new Runnable(){

            @Override
            public void run() {
                try (SQLiteDatabase db = null;){
                    db = AnalyticsDatabase.this.getWritableDatabase();
                    db.delete(AnalyticsDatabase.TABLE_NAME, where.toString(), whereArgs);
                }
            }
        });
        this.queueTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<AnalyticsEvent>> getPendingRequests() {
        ArrayList<List<AnalyticsEvent>> analyticsRequests = new ArrayList<List<AnalyticsEvent>>();
        try (SQLiteDatabase db = null;){
            db = this.getReadableDatabase();
            String[] columns = new String[]{"group_concat(_id)", "group_concat(event)", "group_concat(timestamp)", META_JSON};
            Cursor cursor = db.query(false, TABLE_NAME, columns, null, null, META_JSON, null, "_id asc", null);
            while (cursor.moveToNext()) {
                ArrayList<AnalyticsEvent> innerList = new ArrayList<AnalyticsEvent>();
                String[] ids = cursor.getString(0).split(",");
                String[] events = cursor.getString(1).split(",");
                String[] timestamps = cursor.getString(2).split(",");
                for (int i = 0; i < events.length; ++i) {
                    try {
                        AnalyticsEvent request = new AnalyticsEvent();
                        request.id = Integer.valueOf(ids[i]);
                        request.event = events[i];
                        request.timestamp = Long.valueOf(timestamps[i]);
                        request.metadata = new JSONObject(cursor.getString(cursor.getColumnIndex(META_JSON)));
                        innerList.add(request);
                        continue;
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                analyticsRequests.add(innerList);
            }
            cursor.close();
        }
        return analyticsRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTask(final DatabaseTask task) {
        task.setFinishedCallback(new BraintreeResponseListener<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(Void aVoid) {
                Set<AsyncTask> set = AnalyticsDatabase.this.mTaskSet;
                synchronized (set) {
                    AnalyticsDatabase.this.mTaskSet.remove((Object)task);
                }
            }
        });
        Set<AsyncTask> set = this.mTaskSet;
        synchronized (set) {
            this.mTaskSet.add(task);
        }
        task.execute(new Void[0]);
    }

    private static class DatabaseTask
    extends AsyncTask<Void, Void, Void> {
        private Runnable mDatabaseAction;
        private BraintreeResponseListener<Void> mFinishedCallback;

        public DatabaseTask(Runnable action) {
            this.mDatabaseAction = action;
        }

        protected Void doInBackground(Void ... voids) {
            this.mDatabaseAction.run();
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            if (this.mFinishedCallback != null) {
                this.mFinishedCallback.onResponse(null);
            }
        }

        private void setFinishedCallback(BraintreeResponseListener<Void> callback) {
            this.mFinishedCallback = callback;
        }
    }
}

