/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.res.Resources;
import android.net.Uri;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.R;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.exceptions.PaymentMethodDeleteException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.internal.GraphQLQueryHelper;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.MetadataBuilder;
import com.braintreepayments.api.models.PaymentMethodNonce;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentMethod {
    protected static final String SINGLE_USE_TOKEN_ID = "singleUseTokenId";
    protected static final String VARIABLES = "variables";
    protected static final String INPUT = "input";
    protected static final String CLIENT_SDK_META_DATA = "clientSdkMetadata";

    public static void getPaymentMethodNonces(final BraintreeFragment fragment, boolean defaultFirst) {
        final Uri uri = Uri.parse((String)TokenizationClient.versionedPath("payment_methods")).buildUpon().appendQueryParameter("default_first", String.valueOf(defaultFirst)).appendQueryParameter("session_id", fragment.getSessionId()).build();
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                fragment.getHttpClient().get(uri.toString(), new HttpResponseCallback(){

                    public void success(String responseBody) {
                        try {
                            fragment.postCallback(PaymentMethodNonce.parsePaymentMethodNonces(responseBody));
                            fragment.sendAnalyticsEvent("get-payment-methods.succeeded");
                        }
                        catch (JSONException e) {
                            fragment.postCallback((Exception)((Object)e));
                            fragment.sendAnalyticsEvent("get-payment-methods.failed");
                        }
                    }

                    public void failure(Exception exception) {
                        fragment.postCallback(exception);
                        fragment.sendAnalyticsEvent("get-payment-methods.failed");
                    }
                });
            }
        });
    }

    public static void getPaymentMethodNonces(BraintreeFragment fragment) {
        PaymentMethod.getPaymentMethodNonces(fragment, false);
    }

    public static void deletePaymentMethod(final BraintreeFragment fragment, final PaymentMethodNonce paymentMethodNonce) {
        boolean usesClientToken = fragment.getAuthorization() instanceof ClientToken;
        if (!usesClientToken) {
            fragment.postCallback(new BraintreeException("A client token with a customer id must be used to delete a payment method nonce."));
            return;
        }
        JSONObject base = new JSONObject();
        JSONObject variables = new JSONObject();
        JSONObject input = new JSONObject();
        try {
            base.put(CLIENT_SDK_META_DATA, (Object)new MetadataBuilder().sessionId(fragment.getSessionId()).source("client").integration(fragment.getIntegrationType()).build());
            base.put("query", (Object)GraphQLQueryHelper.getQuery(fragment.getApplicationContext(), R.raw.delete_payment_method_mutation));
            input.put(SINGLE_USE_TOKEN_ID, (Object)paymentMethodNonce.getNonce());
            variables.put(INPUT, (Object)input);
            base.put(VARIABLES, (Object)variables);
            base.put("operationName", (Object)"DeletePaymentMethodFromSingleUseToken");
        }
        catch (Resources.NotFoundException | IOException | JSONException e) {
            fragment.postCallback(new BraintreeException("Unable to read GraphQL query"));
        }
        fragment.getGraphQLHttpClient().post(base.toString(), new HttpResponseCallback(){

            public void success(String responseBody) {
                fragment.postPaymentMethodDeletedCallback(paymentMethodNonce);
                fragment.sendAnalyticsEvent("delete-payment-methods.succeeded");
            }

            public void failure(Exception exception) {
                fragment.postCallback(new PaymentMethodDeleteException(paymentMethodNonce, exception));
                fragment.sendAnalyticsEvent("delete-payment-methods.failed");
            }
        });
    }
}

