/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.BraintreeFragment;
import java.io.PrintWriter;
import java.io.StringWriter;

class CrashReporter
implements Thread.UncaughtExceptionHandler {
    private BraintreeFragment mBraintreeFragment;
    private Thread.UncaughtExceptionHandler mDefaultExceptionHandler;

    static CrashReporter setup(BraintreeFragment fragment) {
        return new CrashReporter(fragment);
    }

    private CrashReporter(BraintreeFragment fragment) {
        this.mBraintreeFragment = fragment;
        this.mDefaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    void tearDown() {
        Thread.setDefaultUncaughtExceptionHandler(this.mDefaultExceptionHandler);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        if (stringWriter.toString().contains("com.braintreepayments") || stringWriter.toString().contains("com.paypal")) {
            this.mBraintreeFragment.sendAnalyticsEvent("crash");
        }
        if (this.mDefaultExceptionHandler != null) {
            this.mDefaultExceptionHandler.uncaughtException(thread, ex);
        }
    }
}

