/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.braintreepayments.api.ConfigurationManager;
import com.braintreepayments.api.CrashReporter;
import com.braintreepayments.api.GooglePayment;
import com.braintreepayments.api.LocalPayment;
import com.braintreepayments.api.PayPal;
import com.braintreepayments.api.PayPalTwoFactorAuth;
import com.braintreepayments.api.ThreeDSecure;
import com.braintreepayments.api.Venmo;
import com.braintreepayments.api.VisaCheckoutFacade;
import com.braintreepayments.api.exceptions.BraintreeException;
import com.braintreepayments.api.exceptions.ConfigurationException;
import com.braintreepayments.api.exceptions.GoogleApiClientException;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.interfaces.AmericanExpressListener;
import com.braintreepayments.api.interfaces.BraintreeCancelListener;
import com.braintreepayments.api.interfaces.BraintreeErrorListener;
import com.braintreepayments.api.interfaces.BraintreeListener;
import com.braintreepayments.api.interfaces.BraintreePaymentResultListener;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCreatedListener;
import com.braintreepayments.api.interfaces.PaymentMethodNonceDeletedListener;
import com.braintreepayments.api.interfaces.PaymentMethodNoncesUpdatedListener;
import com.braintreepayments.api.interfaces.QueuedCallback;
import com.braintreepayments.api.interfaces.UnionPayListener;
import com.braintreepayments.api.internal.AnalyticsDatabase;
import com.braintreepayments.api.internal.AnalyticsEvent;
import com.braintreepayments.api.internal.AnalyticsIntentService;
import com.braintreepayments.api.internal.AnalyticsSender;
import com.braintreepayments.api.internal.BraintreeApiHttpClient;
import com.braintreepayments.api.internal.BraintreeGraphQLHttpClient;
import com.braintreepayments.api.internal.BraintreeHttpClient;
import com.braintreepayments.api.internal.IntegrationType;
import com.braintreepayments.api.internal.UUIDHelper;
import com.braintreepayments.api.models.AmericanExpressRewardsBalance;
import com.braintreepayments.api.models.Authorization;
import com.braintreepayments.api.models.BraintreePaymentResult;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.GooglePaymentConfiguration;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.TokenizationKey;
import com.braintreepayments.api.models.UnionPayCapabilities;
import com.braintreepayments.browserswitch.BrowserSwitchFragment;
import com.braintreepayments.browserswitch.BrowserSwitchResult;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.wallet.Wallet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import org.json.JSONException;

public class BraintreeFragment
extends BrowserSwitchFragment {
    @Deprecated
    public static final String TAG = "com.braintreepayments.api.BraintreeFragment";
    public static final String EXTRA_WAS_BROWSER_SWITCH_RESULT = "com.braintreepayments.api.WAS_BROWSER_SWITCH_RESULT";
    private static final String EXTRA_AUTHORIZATION_TOKEN = "com.braintreepayments.api.EXTRA_AUTHORIZATION_TOKEN";
    private static final String EXTRA_INTEGRATION_TYPE = "com.braintreepayments.api.EXTRA_INTEGRATION_TYPE";
    private static final String EXTRA_SESSION_ID = "com.braintreepayments.api.EXTRA_SESSION_ID";
    private static final String TAG_PREFIX = "BraintreeFragment";
    @VisibleForTesting
    static final String EXTRA_CONFIGURATION = "com.braintreepayments.api.EXTRA_CONFIGURATION";
    @VisibleForTesting
    static final String EXTRA_CACHED_PAYMENT_METHOD_NONCES = "com.braintreepayments.api.EXTRA_CACHED_PAYMENT_METHOD_NONCES";
    @VisibleForTesting
    static final String EXTRA_FETCHED_PAYMENT_METHOD_NONCES = "com.braintreepayments.api.EXTRA_FETCHED_PAYMENT_METHOD_NONCES";
    @VisibleForTesting
    protected BraintreeHttpClient mHttpClient;
    @VisibleForTesting
    protected BraintreeApiHttpClient mBraintreeApiClient;
    @VisibleForTesting
    protected BraintreeGraphQLHttpClient mGraphQLHttpClient;
    @VisibleForTesting
    protected GoogleApiClient mGoogleApiClient;
    private CrashReporter mCrashReporter;
    private Authorization mAuthorization;
    private Configuration mConfiguration;
    private final Queue<QueuedCallback> mCallbackQueue = new ArrayDeque<QueuedCallback>();
    private final List<PaymentMethodNonce> mCachedPaymentMethodNonces = new ArrayList<PaymentMethodNonce>();
    private boolean mHasFetchedPaymentMethodNonces = false;
    private boolean mNewActivityNeedsConfiguration;
    private int mConfigurationRequestAttempts = 0;
    private String mIntegrationType;
    private String mSessionId;
    private String mReturnUrlScheme;
    private AnalyticsDatabase mAnalyticsDatabase;
    private ConfigurationListener mConfigurationListener;
    private BraintreeResponseListener<Exception> mConfigurationErrorListener;
    private BraintreeCancelListener mCancelListener;
    private PaymentMethodNoncesUpdatedListener mPaymentMethodNoncesUpdatedListener;
    private PaymentMethodNonceCreatedListener mPaymentMethodNonceCreatedListener;
    private PaymentMethodNonceDeletedListener mPaymentMethodNonceDeletedListener;
    private BraintreeErrorListener mErrorListener;
    private BraintreePaymentResultListener mBraintreePaymentResultListener;
    private UnionPayListener mUnionPayListener;
    private AmericanExpressListener mAmericanExpressListener;
    protected Context mContext;

    public static BraintreeFragment newInstance(AppCompatActivity activity, String authorization) throws InvalidArgumentException {
        if (activity == null) {
            throw new InvalidArgumentException("Activity is null");
        }
        return BraintreeFragment.newInstance((Context)activity, activity.getSupportFragmentManager(), authorization);
    }

    public static BraintreeFragment newInstance(FragmentActivity activity, String authorization) throws InvalidArgumentException {
        if (activity == null) {
            throw new InvalidArgumentException("Activity is null");
        }
        return BraintreeFragment.newInstance((Context)activity, activity.getSupportFragmentManager(), authorization);
    }

    public static BraintreeFragment newInstance(Fragment fragment, String authorization) throws InvalidArgumentException {
        if (fragment == null) {
            throw new InvalidArgumentException("Fragment is null");
        }
        return BraintreeFragment.newInstance(fragment.getContext(), fragment.getChildFragmentManager(), authorization);
    }

    private static BraintreeFragment newInstance(Context context, FragmentManager fragmentManager, String authorization) throws InvalidArgumentException {
        BraintreeFragment braintreeFragment;
        block15: {
            if (context == null) {
                throw new InvalidArgumentException("Context is null");
            }
            if (fragmentManager == null) {
                throw new InvalidArgumentException("FragmentManager is null");
            }
            if (authorization == null) {
                throw new InvalidArgumentException("Tokenization Key or Client Token is null.");
            }
            String tag = "BraintreeFragment." + UUID.nameUUIDFromBytes(authorization.getBytes());
            if (fragmentManager.findFragmentByTag(tag) != null) {
                return (BraintreeFragment)fragmentManager.findFragmentByTag(tag);
            }
            braintreeFragment = new BraintreeFragment();
            Bundle bundle = new Bundle();
            try {
                Authorization auth = Authorization.fromString(authorization);
                bundle.putParcelable(EXTRA_AUTHORIZATION_TOKEN, (Parcelable)auth);
            }
            catch (InvalidArgumentException e) {
                throw new InvalidArgumentException("Tokenization Key or client token was invalid.");
            }
            bundle.putString(EXTRA_SESSION_ID, UUIDHelper.getFormattedUUID());
            bundle.putString(EXTRA_INTEGRATION_TYPE, IntegrationType.get(context));
            braintreeFragment.setArguments(bundle);
            try {
                if (Build.VERSION.SDK_INT >= 24) {
                    try {
                        fragmentManager.beginTransaction().add((Fragment)braintreeFragment, tag).commitNow();
                    }
                    catch (IllegalStateException | NullPointerException e) {
                        fragmentManager.beginTransaction().add((Fragment)braintreeFragment, tag).commit();
                        try {
                            fragmentManager.executePendingTransactions();
                            break block15;
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                    break block15;
                }
                fragmentManager.beginTransaction().add((Fragment)braintreeFragment, tag).commit();
                try {
                    fragmentManager.executePendingTransactions();
                }
                catch (IllegalStateException e) {}
            }
            catch (IllegalStateException e) {
                throw new InvalidArgumentException(e.getMessage());
            }
        }
        braintreeFragment.mContext = context.getApplicationContext();
        return braintreeFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.mNewActivityNeedsConfiguration = false;
        this.mCrashReporter = CrashReporter.setup(this);
        this.mSessionId = this.getArguments().getString(EXTRA_SESSION_ID);
        this.mIntegrationType = this.getArguments().getString(EXTRA_INTEGRATION_TYPE);
        this.mAuthorization = (Authorization)this.getArguments().getParcelable(EXTRA_AUTHORIZATION_TOKEN);
        this.mAnalyticsDatabase = AnalyticsDatabase.getInstance(this.getApplicationContext());
        if (this.mHttpClient == null) {
            this.mHttpClient = new BraintreeHttpClient(this.mAuthorization);
        }
        if (savedInstanceState != null) {
            ArrayList paymentMethodNonces = savedInstanceState.getParcelableArrayList(EXTRA_CACHED_PAYMENT_METHOD_NONCES);
            if (paymentMethodNonces != null) {
                this.mCachedPaymentMethodNonces.addAll(paymentMethodNonces);
            }
            this.mHasFetchedPaymentMethodNonces = savedInstanceState.getBoolean(EXTRA_FETCHED_PAYMENT_METHOD_NONCES);
            try {
                this.setConfiguration(Configuration.fromJson(savedInstanceState.getString(EXTRA_CONFIGURATION)));
            }
            catch (JSONException jSONException) {}
        } else if (this.mAuthorization instanceof TokenizationKey) {
            this.sendAnalyticsEvent("started.client-key");
        } else {
            this.sendAnalyticsEvent("started.client-token");
        }
        this.fetchConfiguration();
    }

    @TargetApi(value=23)
    public void onAttach(Context context) {
        super.onAttach(context);
        this.onAttach((Activity)this.getActivity());
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mNewActivityNeedsConfiguration = true;
        if (this.mContext == null) {
            this.mContext = activity.getApplicationContext();
        }
        this.mReturnUrlScheme = this.mContext.getPackageName().toLowerCase(Locale.ROOT).replace("_", "") + ".braintree";
    }

    public void onResume() {
        super.onResume();
        if (this.getActivity() instanceof BraintreeListener) {
            this.addListener((BraintreeListener)this.getActivity());
            if (this.mNewActivityNeedsConfiguration && this.getConfiguration() != null) {
                this.mNewActivityNeedsConfiguration = false;
                this.postConfigurationCallback();
            }
        }
        this.flushCallbacks();
        if (this.mGoogleApiClient != null && !this.mGoogleApiClient.isConnected() && !this.mGoogleApiClient.isConnecting()) {
            this.mGoogleApiClient.connect();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.getActivity() instanceof BraintreeListener) {
            this.removeListener((BraintreeListener)this.getActivity());
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelableArrayList(EXTRA_CACHED_PAYMENT_METHOD_NONCES, (ArrayList)this.mCachedPaymentMethodNonces);
        outState.putBoolean(EXTRA_FETCHED_PAYMENT_METHOD_NONCES, this.mHasFetchedPaymentMethodNonces);
        if (this.mConfiguration != null) {
            outState.putString(EXTRA_CONFIGURATION, this.mConfiguration.toJson());
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.disconnect();
        }
        this.flushAnalyticsEvents();
    }

    public void onDetach() {
        super.onDetach();
        if (this.mGoogleApiClient != null) {
            this.mGoogleApiClient.disconnect();
            this.mGoogleApiClient = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCrashReporter.tearDown();
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (!this.isAdded()) {
            this.postCallback(new BraintreeException("BraintreeFragment is not attached to an Activity. Please ensure it is attached and try again."));
        } else {
            super.startActivityForResult(intent, requestCode);
        }
    }

    public String getReturnUrlScheme() {
        return this.mReturnUrlScheme;
    }

    public void onBrowserSwitchResult(int requestCode, BrowserSwitchResult browserSwitchResult, @Nullable Uri uri) {
        String type = "";
        Intent intent = new Intent().putExtra(EXTRA_WAS_BROWSER_SWITCH_RESULT, true);
        switch (requestCode) {
            case 13591: {
                type = "paypal";
                break;
            }
            case 13487: {
                type = "three-d-secure";
                break;
            }
            case 13596: {
                type = "local-payment";
            }
        }
        int resultCode = 1;
        if (browserSwitchResult.getStatus() == 1) {
            resultCode = -1;
            this.sendAnalyticsEvent(type + ".browser-switch.succeeded");
        } else if (browserSwitchResult.getStatus() == 2) {
            resultCode = 0;
            this.sendAnalyticsEvent(type + ".browser-switch.canceled");
        } else if (browserSwitchResult.getStatus() == 3) {
            String errorMessage = browserSwitchResult.getErrorMessage();
            if (errorMessage != null && errorMessage.startsWith("No installed activities")) {
                this.sendAnalyticsEvent(type + ".browser-switch.failed.no-browser-installed");
            } else {
                this.sendAnalyticsEvent(type + ".browser-switch.failed.not-setup");
            }
        }
        this.onActivityResult(requestCode, resultCode, intent.setData(uri));
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 13591: {
                PayPal.onActivityResult(this, resultCode, data);
                break;
            }
            case 13487: {
                ThreeDSecure.onActivityResult(this, resultCode, data);
                break;
            }
            case 13488: {
                Venmo.onActivityResult(this, resultCode, data);
                break;
            }
            case 13592: {
                VisaCheckoutFacade.onActivityResult(this, resultCode, data);
                break;
            }
            case 13596: {
                LocalPayment.onActivityResult(this, resultCode, data);
                break;
            }
            case 13593: {
                GooglePayment.onActivityResult((BraintreeFragment)this, (int)resultCode, (Intent)data);
                break;
            }
            case 13597: {
                PayPalTwoFactorAuth.onActivityResult(this, resultCode, data);
            }
        }
        if (resultCode == 0) {
            this.postCancelCallback(requestCode);
        }
    }

    public <T extends BraintreeListener> void addListener(T listener) {
        if (listener instanceof ConfigurationListener) {
            this.mConfigurationListener = (ConfigurationListener)listener;
        }
        if (listener instanceof BraintreeCancelListener) {
            this.mCancelListener = (BraintreeCancelListener)listener;
        }
        if (listener instanceof PaymentMethodNoncesUpdatedListener) {
            this.mPaymentMethodNoncesUpdatedListener = (PaymentMethodNoncesUpdatedListener)listener;
        }
        if (listener instanceof PaymentMethodNonceCreatedListener) {
            this.mPaymentMethodNonceCreatedListener = (PaymentMethodNonceCreatedListener)listener;
        }
        if (listener instanceof PaymentMethodNonceDeletedListener) {
            this.mPaymentMethodNonceDeletedListener = (PaymentMethodNonceDeletedListener)listener;
        }
        if (listener instanceof BraintreePaymentResultListener) {
            this.mBraintreePaymentResultListener = (BraintreePaymentResultListener)listener;
        }
        if (listener instanceof BraintreeErrorListener) {
            this.mErrorListener = (BraintreeErrorListener)listener;
        }
        if (listener instanceof UnionPayListener) {
            this.mUnionPayListener = (UnionPayListener)listener;
        }
        if (listener instanceof AmericanExpressListener) {
            this.mAmericanExpressListener = (AmericanExpressListener)listener;
        }
        this.flushCallbacks();
    }

    public <T extends BraintreeListener> void removeListener(T listener) {
        if (listener instanceof ConfigurationListener) {
            this.mConfigurationListener = null;
        }
        if (listener instanceof BraintreeCancelListener) {
            this.mCancelListener = null;
        }
        if (listener instanceof PaymentMethodNoncesUpdatedListener) {
            this.mPaymentMethodNoncesUpdatedListener = null;
        }
        if (listener instanceof PaymentMethodNonceCreatedListener) {
            this.mPaymentMethodNonceCreatedListener = null;
        }
        if (listener instanceof PaymentMethodNonceDeletedListener) {
            this.mPaymentMethodNonceDeletedListener = null;
        }
        if (listener instanceof BraintreePaymentResultListener) {
            this.mBraintreePaymentResultListener = null;
        }
        if (listener instanceof BraintreeErrorListener) {
            this.mErrorListener = null;
        }
        if (listener instanceof UnionPayListener) {
            this.mUnionPayListener = null;
        }
        if (listener instanceof AmericanExpressListener) {
            this.mAmericanExpressListener = null;
        }
    }

    public List<BraintreeListener> getListeners() {
        ArrayList<BraintreeListener> listeners = new ArrayList<BraintreeListener>();
        if (this.mConfigurationListener != null) {
            listeners.add(this.mConfigurationListener);
        }
        if (this.mCancelListener != null) {
            listeners.add(this.mCancelListener);
        }
        if (this.mPaymentMethodNoncesUpdatedListener != null) {
            listeners.add(this.mPaymentMethodNoncesUpdatedListener);
        }
        if (this.mPaymentMethodNonceCreatedListener != null) {
            listeners.add(this.mPaymentMethodNonceCreatedListener);
        }
        if (this.mPaymentMethodNonceDeletedListener != null) {
            listeners.add(this.mPaymentMethodNonceDeletedListener);
        }
        if (this.mBraintreePaymentResultListener != null) {
            listeners.add(this.mBraintreePaymentResultListener);
        }
        if (this.mErrorListener != null) {
            listeners.add(this.mErrorListener);
        }
        if (this.mUnionPayListener != null) {
            listeners.add(this.mUnionPayListener);
        }
        if (this.mAmericanExpressListener != null) {
            listeners.add(this.mAmericanExpressListener);
        }
        return listeners;
    }

    public boolean hasFetchedPaymentMethodNonces() {
        return this.mHasFetchedPaymentMethodNonces;
    }

    public List<PaymentMethodNonce> getCachedPaymentMethodNonces() {
        return Collections.unmodifiableList(this.mCachedPaymentMethodNonces);
    }

    @VisibleForTesting(otherwise=3)
    public boolean isActive() {
        return this.isAdded();
    }

    public void sendAnalyticsEvent(String eventFragment) {
        final AnalyticsEvent request = new AnalyticsEvent(this.mContext, this.getSessionId(), this.mIntegrationType, eventFragment);
        this.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (configuration.getAnalytics().isEnabled()) {
                    BraintreeFragment.this.mAnalyticsDatabase.addEvent(request);
                }
            }
        });
    }

    private void flushAnalyticsEvents() {
        if (this.getConfiguration() != null && this.getConfiguration().toJson() != null && this.getConfiguration().getAnalytics().isEnabled()) {
            Intent intent = new Intent(this.mContext, AnalyticsIntentService.class).putExtra("com.braintreepayments.api.internal.AnalyticsIntentService.EXTRA_AUTHORIZATION", this.getAuthorization().toString()).putExtra("com.braintreepayments.api.internal.AnalyticsIntentService.EXTRA_CONFIGURATION", this.getConfiguration().toJson());
            try {
                this.getApplicationContext().startService(intent);
            }
            catch (RuntimeException e) {
                AnalyticsSender.send(this.getApplicationContext(), this.mAuthorization, this.getHttpClient(), this.getConfiguration().getAnalytics().getUrl(), false);
            }
        }
    }

    protected void postConfigurationCallback() {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mConfigurationListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mConfigurationListener.onConfigurationFetched(BraintreeFragment.this.getConfiguration());
            }
        });
    }

    protected void postCancelCallback(final int requestCode) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mCancelListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mCancelListener.onCancel(requestCode);
            }
        });
    }

    protected void postCallback(final PaymentMethodNonce paymentMethodNonce) {
        this.mCachedPaymentMethodNonces.add(0, paymentMethodNonce);
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mPaymentMethodNonceCreatedListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mPaymentMethodNonceCreatedListener.onPaymentMethodNonceCreated(paymentMethodNonce);
            }
        });
    }

    protected void postCallback(final UnionPayCapabilities capabilities) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mUnionPayListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mUnionPayListener.onCapabilitiesFetched(capabilities);
            }
        });
    }

    protected void postUnionPayCallback(final String enrollmentId, final boolean smsCodeRequired) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mUnionPayListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mUnionPayListener.onSmsCodeSent(enrollmentId, smsCodeRequired);
            }
        });
    }

    protected void postCallback(final BraintreePaymentResult result) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mBraintreePaymentResultListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mBraintreePaymentResultListener.onBraintreePaymentResult(result);
            }
        });
    }

    protected void postAmericanExpressCallback(final AmericanExpressRewardsBalance rewardsBalance) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mAmericanExpressListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mAmericanExpressListener.onRewardsBalanceFetched(rewardsBalance);
            }
        });
    }

    protected void postCallback(final List<PaymentMethodNonce> paymentMethodNonceList) {
        this.mCachedPaymentMethodNonces.clear();
        this.mCachedPaymentMethodNonces.addAll(paymentMethodNonceList);
        this.mHasFetchedPaymentMethodNonces = true;
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mPaymentMethodNoncesUpdatedListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mPaymentMethodNoncesUpdatedListener.onPaymentMethodNoncesUpdated(paymentMethodNonceList);
            }
        });
    }

    protected void postPaymentMethodDeletedCallback(final PaymentMethodNonce paymentMethodNonce) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mPaymentMethodNonceDeletedListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mPaymentMethodNonceDeletedListener.onPaymentMethodNonceDeleted(paymentMethodNonce);
            }
        });
    }

    protected void postCallback(final Exception error) {
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.mErrorListener != null;
            }

            @Override
            public void run() {
                BraintreeFragment.this.mErrorListener.onError(error);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void postOrQueueCallback(QueuedCallback callback) {
        if (!callback.shouldRun()) {
            Queue<QueuedCallback> queue = this.mCallbackQueue;
            synchronized (queue) {
                this.mCallbackQueue.add(callback);
            }
        } else {
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void flushCallbacks() {
        Queue<QueuedCallback> queue = this.mCallbackQueue;
        synchronized (queue) {
            ArrayDeque<QueuedCallback> queue2 = new ArrayDeque<QueuedCallback>(this.mCallbackQueue);
            for (QueuedCallback callback : queue2) {
                if (!callback.shouldRun()) continue;
                callback.run();
                this.mCallbackQueue.remove(callback);
            }
        }
    }

    @VisibleForTesting
    protected void fetchConfiguration() {
        if (this.getConfiguration() != null || ConfigurationManager.isFetchingConfiguration() || this.mAuthorization == null || this.mHttpClient == null) {
            return;
        }
        if (this.mConfigurationRequestAttempts >= 3) {
            this.postCallback(new ConfigurationException("Configuration retry limit has been exceeded. Create a new BraintreeFragment and try again."));
            return;
        }
        ++this.mConfigurationRequestAttempts;
        ConfigurationManager.getConfiguration(this, new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                BraintreeFragment.this.setConfiguration(configuration);
                BraintreeFragment.this.postConfigurationCallback();
                BraintreeFragment.this.flushCallbacks();
            }
        }, new BraintreeResponseListener<Exception>(){

            @Override
            public void onResponse(Exception e) {
                final ConfigurationException exception = new ConfigurationException("Request for configuration has failed: " + e.getMessage() + ". Future requests will retry up to 3 times", e);
                BraintreeFragment.this.postCallback(exception);
                BraintreeFragment.this.postOrQueueCallback(new QueuedCallback(){

                    @Override
                    public boolean shouldRun() {
                        return BraintreeFragment.this.mConfigurationErrorListener != null;
                    }

                    @Override
                    public void run() {
                        BraintreeFragment.this.mConfigurationErrorListener.onResponse(exception);
                    }
                });
                BraintreeFragment.this.flushCallbacks();
            }
        });
    }

    protected void setConfigurationErrorListener(BraintreeResponseListener<Exception> listener) {
        this.mConfigurationErrorListener = listener;
    }

    protected void waitForConfiguration(final ConfigurationListener listener) {
        this.fetchConfiguration();
        this.postOrQueueCallback(new QueuedCallback(){

            @Override
            public boolean shouldRun() {
                return BraintreeFragment.this.getConfiguration() != null && BraintreeFragment.this.isAdded();
            }

            @Override
            public void run() {
                listener.onConfigurationFetched(BraintreeFragment.this.getConfiguration());
            }
        });
    }

    protected Authorization getAuthorization() {
        return this.mAuthorization;
    }

    protected Context getApplicationContext() {
        return this.mContext;
    }

    protected Configuration getConfiguration() {
        return this.mConfiguration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.mConfiguration = configuration;
        this.getHttpClient().setBaseUrl(configuration.getClientApiUrl());
        if (configuration.getGraphQL().isEnabled()) {
            this.mGraphQLHttpClient = new BraintreeGraphQLHttpClient(configuration.getGraphQL().getUrl(), this.mAuthorization.getBearer());
        }
    }

    protected BraintreeHttpClient getHttpClient() {
        return this.mHttpClient;
    }

    @Nullable
    protected BraintreeApiHttpClient getBraintreeApiHttpClient() {
        if (this.mBraintreeApiClient == null && this.getConfiguration() != null && this.getConfiguration().getBraintreeApiConfiguration().isEnabled()) {
            this.mBraintreeApiClient = new BraintreeApiHttpClient(this.getConfiguration().getBraintreeApiConfiguration().getUrl(), this.getConfiguration().getBraintreeApiConfiguration().getAccessToken());
        }
        return this.mBraintreeApiClient;
    }

    @Nullable
    protected BraintreeGraphQLHttpClient getGraphQLHttpClient() {
        return this.mGraphQLHttpClient;
    }

    protected String getSessionId() {
        return this.mSessionId;
    }

    protected String getIntegrationType() {
        return this.mIntegrationType;
    }

    public void getGoogleApiClient(final BraintreeResponseListener<GoogleApiClient> listener) {
        this.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                GoogleApiClient googleApiClient = BraintreeFragment.this.getGoogleApiClient();
                if (googleApiClient != null) {
                    listener.onResponse(googleApiClient);
                }
            }
        });
    }

    protected GoogleApiClient getGoogleApiClient() {
        if (this.getActivity() == null) {
            this.postCallback(new GoogleApiClientException(GoogleApiClientException.ErrorType.NotAttachedToActivity, 1));
            return null;
        }
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this.getActivity()).addApi(Wallet.API, (Api.ApiOptions.HasOptions)new Wallet.WalletOptions.Builder().setEnvironment(GooglePayment.getEnvironment((GooglePaymentConfiguration)this.getConfiguration().getGooglePayment())).setTheme(1).build()).build();
        }
        if (!this.mGoogleApiClient.isConnected() && !this.mGoogleApiClient.isConnecting()) {
            this.mGoogleApiClient.registerConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

                public void onConnected(Bundle bundle) {
                }

                public void onConnectionSuspended(int i) {
                    BraintreeFragment.this.postCallback(new GoogleApiClientException(GoogleApiClientException.ErrorType.ConnectionSuspended, i));
                }
            });
            this.mGoogleApiClient.registerConnectionFailedListener(new GoogleApiClient.OnConnectionFailedListener(){

                public void onConnectionFailed(ConnectionResult connectionResult) {
                    BraintreeFragment.this.postCallback(new GoogleApiClientException(GoogleApiClientException.ErrorType.ConnectionFailed, connectionResult.getErrorCode()));
                }
            });
            this.mGoogleApiClient.connect();
        }
        return this.mGoogleApiClient;
    }
}

